//
// KBlackBox
//
// A simple game inspired by an emacs module
//
/***************************************************************************
 *   Copyright (c) 1999-2000, Robert Cimrman                               *
 *   cimrman3@students.zcu.cz                                              *
 *                                                                         *
 *   Copyright (c) 2007, Nicolas Roffet                                    *
 *   nicolas-kde@roffet.com                                                *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/



#ifndef KBBGRAPHICSITEMBORDER_H
#define KBBGRAPHICSITEMBORDER_H



/**
 * @brief Any border element of the scalable graphic widget
 */
class KBBGraphicsItemBorder
{
	public:
		KBBGraphicsItemBorder(const int borderPosition, const int columns, const int rows, const int offset);


	protected:
		void centerCoordinate(const int borderPosition, int &centerX, int &centerY, const int offset);
		int rotation();

		int m_borderPosition;
		int m_centerX;
		int m_centerY;
		int m_columns;
		int m_rows;
};

#endif // KBBGRAPHICSITEMBORDER_H
