#include "settings.h"
#include "settings.moc"

#include <QLabel>
#include <QVBoxLayout>
#include <QGridLayout>
#include <QCheckBox>
#include <QGroupBox>
#include <knuminput.h>
#include <klocale.h>
#include <kcolorbutton.h>
#include <kdialog.h>

#include "piece.h"
#include "factory.h"


//-----------------------------------------------------------------------------
BaseAppearanceConfig::BaseAppearanceConfig()
{
    setObjectName("appearance_config");
    QVBoxLayout *top = new QVBoxLayout(this);

    // upper part
    _main = new QWidget(this);
    top->addWidget(_main);
    _grid = new QGridLayout(_main);
    _grid->setMargin(0);
    _grid->setSpacing(KDialog::spacingHint());
    _grid->setColumnStretch(1, 1);

    QCheckBox *chb =
        new QCheckBox(i18n("Enable animations"), _main);
    chb->setObjectName("kcfg_AnimationsEnabled");
    _grid->addWidget(chb, 2, 0, 1, 2);

    top->addSpacing(KDialog::spacingHint());

    // lower part
    QGroupBox *gbox = new QGroupBox( i18n("Background"), this);
    top->addWidget(gbox);
    QVBoxLayout* vboxForGBox = new QVBoxLayout(gbox);
    QWidget *widget = new QWidget(gbox);
    vboxForGBox->addWidget(widget);
    QGridLayout *grid = new QGridLayout(widget);
    grid->setMargin(0);
    grid->setSpacing(KDialog::spacingHint());
    grid->setColumnStretch(2, 1);
    QLabel *label = new QLabel(i18n("Color:"), widget);
    grid->addWidget(label, 0, 0);
    KColorButton *cob = new KColorButton(widget);
    cob->setObjectName("kcfg_FadeColor");
    cob->setFixedWidth(100);
    grid->addWidget(cob, 0, 1);
    label = new QLabel(i18n("Opacity:"), widget);
    grid->addWidget(label, 1, 0);
    KDoubleNumInput *dn = new KDoubleNumInput(widget);
    dn->setObjectName("kcfg_FadeIntensity");
    dn->setRange(0.0, 1.0, 0.01);
    grid->addWidget(dn, 1, 1, 1, 2);

    top->addStretch(1);
}

//-----------------------------------------------------------------------------
ColorConfig::ColorConfig()
{
    setObjectName("color_config");
    const GPieceInfo &info = Piece::info();
    QVBoxLayout *top = new QVBoxLayout(this);
    uint nb = info.nbColors();
    QGridLayout *grid = new QGridLayout;
    grid->setSpacing(KDialog::spacingHint());
    grid->setColumnStretch(2, 1);
    top->addLayout(grid);
    for (uint i=0; i<nb; i++) {
        QLabel *label = new QLabel(info.colorLabel(i), this);
        grid->addWidget(label, i, 0);
        KColorButton *cob = new KColorButton(this);
        cob->setObjectName(colorKey(i));
        cob->setFixedWidth(100);
        grid->addWidget(cob, i, 1);
    }
    grid->setRowStretch(nb, 1);
}

QByteArray ColorConfig::colorKey(uint i)
{
    QByteArray s;
    s.setNum(i);
    return "kcfg_Color" + s;
}

