#ifndef PLINE_H
#define PLINE_H

#include <QList>
#include <QFrame>

#include "types.h"

class QPushButton;
class QLineEdit;
class QVBoxLayout;
class QHBoxLayout;
class QLabel;

/** Internal class : display a "player line" in netmeeting. */
class MeetingLine : public QFrame
{
 Q_OBJECT

 public:
    MeetingLine(bool isOwner, bool readerIsServer, bool serverLine,
				QWidget *parent);

	MeetingCheckBox::Type type() const { return tcb->type(); }
	void setType(MeetingCheckBox::Type type) { tcb->setType(type); }
	void setText(const QString &text);

	void setData(const ExtData &ed);
	void data(ExtData &ed) const;
	QString text() const;

 signals:
	void typeChanged(MeetingCheckBox::Type);
	void textChanged(const QString &);

 private slots:
	void _typeChanged(int t)
		{ emit typeChanged((MeetingCheckBox::Type)t); };
	void _textChanged(const QString &text) { emit textChanged(text); }

 protected:
	QHBoxLayout *hbl;

 private:
	MeetingCheckBox       *tcb;
	QLabel                *lname, *labH, *labAI;
	QList<BoardData>  bds;
	QLineEdit             *qle;
};

class PlayerLine : public QFrame
{
 Q_OBJECT

 public:
	PlayerLine(PlayerComboBox::Type type, const QString &txt,
			   bool humanSetting, bool AISetting,
			   bool canBeEmpty, bool acceptAI,
			   QWidget *parent = 0);

	PlayerComboBox::Type type() const { return pcb->type(); }
	QString name() const;

 signals:
	void setHuman();
	void setAI();
	void typeChanged(int);

 private slots:
	void setSlot();
	void typeChangedSlot(int);

 private:
	PlayerComboBox *pcb;
	QLineEdit      *edit;
	QPushButton    *setting;
	bool            hs, as;
};

/** Internal class : scrolable list of widgets. */
class GWidgetList : public QWidget
{
 Q_OBJECT

 public:
	GWidgetList(uint interval, QWidget *parent = 0);

	void remove(uint i);
	uint size() const { return widgets.count(); }

 protected:
	/** The widget must be created with this widget as parent. */
	void append(QWidget *);
	QWidget *widget(uint i) { return widgets.at(i); }

 private:
	QList<QWidget*> widgets;
	QVBoxLayout* vbl;
};

template <class Type>
class WidgetList : public GWidgetList
{
 public:
	WidgetList(uint interval, QWidget *parent=0)
	: GWidgetList(interval, parent) {}

	void append(Type *w) { GWidgetList::append(w); }
	Type *widget(uint i) { return (Type *)GWidgetList::widget(i); }
};

#endif // PLINE_H
