# - Try to find the kdegames library
# Once done this will define
#
#  KDEGAMES_FOUND - system has the kdegames library
#  KDEGAMES_INCLUDE_DIR - the kdegames include directory
#  KDEGAMES_LIBRARY - Link this to use the kdegames library
#
include(CheckLibraryExists)

if (KDEGAMES_INCLUDE_DIR AND KDEGAMES_LIBRARY)
    # in cache already
    SET(KDEGAMES_FOUND TRUE)

else (KDEGAMES_INCLUDE_DIR AND KDEGAMES_LIBRARY)

	# reset vars
	set(KDEGAMES_INCLUDE_DIR)
	set(KDEGAMES_LIBRARY)
	FIND_PATH(KDEGAMES_INCLUDE_DIR kstandardgameaction.h
  		${INCLUDE_INSTALL_DIR}
                ${KDE4_INCLUDE_DIR} 
  		${GNUWIN32_DIR}/include
	)
	set(KDEGAMES_INCLUDE_DIR ${KDEGAMES_INCLUDE_DIR} CACHE PATH "")

        set(CMAKE_LIBRARY_PATH ${LIB_INSTALL_DIR})
	find_library(KDEGAMES_LIBRARY NAMES kdegames
		PATHS
		${LIB_INSTALL_DIR}
                ${KDE4_LIB_DIR}
  		${GNUWIN32_DIR}/lib
	)
	set(KDEGAMES_LIBRARY ${KDEGAMES_LIBRARY} CACHE STRING "")

	if(KDEGAMES_INCLUDE_DIR AND KDEGAMES_LIBRARY)
  		set(KDEGAMES_FOUND TRUE)
	endif(KDEGAMES_INCLUDE_DIR AND KDEGAMES_LIBRARY)

	if (KDEGAMES_FOUND)
	  if (NOT LibKDEGames_FIND_QUIETLY)
    	message(STATUS "Found lib KDEGames: ${KDEGAMES_LIBRARY}")
	  endif (NOT LibKDEGames_FIND_QUIETLY)
	else (KDEGAMES_FOUND)
	  if (LibKDEGames_FIND_REQUIRED)
	    message(FATAL_ERROR "Could NOT find lib KDEGames")
	  endif (LibKDEGames_FIND_REQUIRED)
	endif (KDEGAMES_FOUND)

	MARK_AS_ADVANCED(KDEGAMES_INCLUDE_DIR KDEGAMES_LIBRARY)
ENDIF(KDEGAMES_INCLUDE_DIR AND KDEGAMES_LIBRARY)

