// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
/***************************************************************************
 *   Copyright (C) 2005-2006 by Wilfried Huss                              *
 *   Wilfried.Huss@gmx.at                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef BOOKMARKLIST_H
#define BOOKMARKLIST_H

#include "dataView.h"
#include "pageNumber.h"

#include <k3listview.h>

#include <QPixmap>

class QAction;
class QMenu;

class BookmarkList;

class BookmarkItem : public K3ListViewItem
{
public:
  BookmarkItem(BookmarkList* parent);

  void set(const PageNumber& _pageNumber, const QString& label);

  PageNumber getPageNumber() const { return pageNumber; };

  virtual int compare(K3ListViewItem* i, int col, bool ascending) const;

private:
  PageNumber pageNumber;

  BookmarkList* bookmarkList;
};


class BookmarkList : public K3ListView, public DataView
{
Q_OBJECT

public:
  BookmarkList(QWidget* parent);
  virtual ~BookmarkList();

  virtual QSize sizeHint() const { return QSize(); }

  virtual void setupObservers(DataModel*);

private slots:
  void setCurrentPage();

  /** @brief Add a bookmark.

      @note connected to the corresponding signal from @ref DataModel */
  void bookmarkAdded(const PageNumber& page, const QString& label);

  /** @brief Rename a bookmark.

      @note connected to the corresponding signal from @ref DataModel */
  void bookmarkRenamed(const PageNumber& page, const QString& label);

  /** @brief Remove a bookmark.

      @note connected to the corresponding signal from @ref DataModel */
  void bookmarkRemoved(const PageNumber& page);

  /** @brief Remove all bookmarks.

      @note connected to the corresponding signal from @ref DataModel */
  void allBookmarksRemoved();

  void itemClicked(Q3ListViewItem*);
  void slotItemRenamed(Q3ListViewItem*, int, const QString&);
  void slotContextMenu(Q3ListViewItem*, const QPoint& pos);

private:
  PageNumber currentPageNumber;

  QPixmap currentBookmarkIcon;

  QMenu* contextMenu;

  QAction* addBookmarkAction;
  QAction* removeBookmarkAction;
  QAction* removeAllBookmarksAction;
  QAction* renameBookmarkAction;
};

#endif
