// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
// history.cpp
//
// (C) 2001 Stefan Kebekus
// Distributed under the GPL

#include <config.h>

#include "history.h"

#include <QList>


void History::add(Anchor a)
{
  // Don't change the history when we are navigating throu the history
  if (a.isHistoryLink)
    return;

  // Make the anchor a history item
  a.isHistoryLink = true;

  if (historyList.empty())
  {
    historyList.append(a);
    currentItem = historyList.begin();
  }
  else
  {
    // Don't add the same item several times in a row
    if (a == *currentItem)
      return;

      currentItem++;
    if (currentItem == historyList.end())
    {
      historyList.append(a);
      currentItem = historyList.end();
      --currentItem; // last element of the list
    }
    else
    {
      currentItem = historyList.insert(currentItem, a);
    }
    // Delete items starting after currentItem to the end of the list.
    QList<Anchor>::iterator deleteItemsStart = currentItem;
    deleteItemsStart++;
    historyList.erase(deleteItemsStart, historyList.end());

    if (historyList.size() > HISTORYLENGTH)
      historyList.pop_front();
  }
  emit backItem(currentItem != historyList.begin());
  emit forwardItem(false);
}


Anchor* History::forward()
{
  QList<Anchor>::iterator lastItem = historyList.end();
  --lastItem;

  if (historyList.empty() || currentItem == lastItem)
    return 0;

  currentItem++;

  emit backItem(true);
  emit forwardItem(currentItem != lastItem);
  return &(*currentItem);
}


Anchor* History::back()
{
  QList<Anchor>::iterator lastItem = historyList.end();

  if (historyList.empty() || currentItem == lastItem)
    return 0;

  currentItem--;

  emit backItem(currentItem != historyList.begin());
  emit forwardItem(true);
  return &(*currentItem);
}


void History::clear()
{
  historyList.clear();
  currentItem = historyList.begin();
  emit backItem(false);
  emit forwardItem(false);
}

#include "history.moc"
