// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
#ifndef LIGATURE_H
#define LIGATURE_H

#include <kparts/mainwindow.h>

#include <QString>

class KRecentFilesAction;
class KToggleAction;
class KToggleFullScreenAction;
class KUrl;
class LigaturePart;
class QLabel;
class KTemporaryFile;


class Ligature : public KParts::MainWindow
{
  Q_OBJECT

public:
  Ligature(const QString& defaultMimeType = QString::null);
  virtual ~Ligature();

public slots:
  void openUrl(const KUrl&);
  void openStdin();
  void addRecentFile();

protected slots:
  void slotFullScreen();
  void slotQuit();
  void slotConfigureKeys();
  void slotEditToolbar();
  void slotFileClose();
  void slotNewToolbarConfig();

  void slotChangeZoomText(const QString &);
  void slotChangePageText(const QString &);
  void slotChangeSizeText(const QString &);

  void showTip();

signals:
  void restoreDocument(const KUrl &url, int page);
  void saveDocumentRestoreInfo(KConfig* config);

protected:
  void readSettings();
  void writeSettings();
  virtual bool queryClose();

  /**
   * This method is called when it is time for the app to save its
   * properties for session management purposes.
   */
  void saveProperties(KConfig*);

  /**
   * This method is called when this app is restored.  The KConfig
   * object points to the session management config file that was saved
   * with @ref saveProperties
   */
  void readProperties(KConfig*);

  void checkActions();

  void dragEnterEvent(QDragEnterEvent* event);
  void dropEvent(QDropEvent* event);
  void keyPressEvent(QKeyEvent* e);

private:
  KStatusBar* statusbar;
  LigaturePart* view;

  KRecentFilesAction* recent;
  QString cwd;

  QAction* closeAction;
  QAction* reloadAction;
  KToggleFullScreenAction* fullScreenAction;

  // In the attribute, the status of the statusbar (shown of hidden)
  // is saved when the ligature switches to fullscreen mode. The
  // statusbar can then be restored when the application returns to normal mode.
  bool isStatusBarShownInNormalMode;
  // ditto, for the toolbar
  bool isToolBarShownInNormalMode;

  // Used for storing data received from stdin
  KTemporaryFile* tmpFile;
};


#endif
