// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
//
// Class: RenderedDocumentPagePixmap
//
// Widget for displaying TeX DVI files.
// Part of KDVI- A previewer for TeX DVI files.
//
// (C) 2004-2005 Stefan Kebekus.
// (C) 2005-2006 Wilfried Huss.
//
// Distributed under the GPL.

#ifndef _rendereddocumentpagepixmap_h_
#define _rendereddocumentpagepixmap_h_

#include "ligature_export.h"

#include "dataView.h"
#include "renderedDocumentPage.h"

#include <QPainter>
#include <QPixmap>
#include <QImage>

/** \brief provides all the information the DocumentRenderer needs to draw a page

@author Wilfried Huss
*/
class LIGATURECORE_EXPORT JobId
{
public:
  JobId()
    : resolution(0.0), rotation(0), isThumbnail(false)
  {}

  JobId(PageNumber p, double _resolution, int _rotation, bool _isThumbnail)
    : pageNumber(p), resolution(_resolution), rotation(_rotation),
      isThumbnail(_isThumbnail)
  {}

  QString key();

  PageNumber pageNumber;

  /** The field resolution contains the resolution of the display
  device. In principle. In fact, ligature implements zooming
  by using values that are not exactly the resolution of the display,
  but multiplied with the zoom factor. Bottom line: the
  DocumentRenderer should act as if this field indeed contains
  resolution of the display device. */
  double resolution;
  int rotation;
  bool isThumbnail;

  bool operator==(const JobId& id) const;
  bool operator!=(const JobId& id) const;
};


// This class contains everything documentRenderer needs to know
// about a certain page.
class LIGATURECORE_EXPORT RenderedDocumentPagePixmap: public RenderedDocumentPage, public DataView
{
  Q_OBJECT

public:
  RenderedDocumentPagePixmap(JobId _id);

  virtual ~RenderedDocumentPagePixmap();

  virtual void setupObservers(DataModel*);

  virtual void setPageNumber(const PageNumber&);

  QPixmap pixmap();

  void setImage(QImage image);
  void paintImage();

  void resizePixmaps();

  void resize(const QSize& size);
  void resize(int width, int height);

  virtual QSize size() { return sizeInPixels; }
  virtual int width() { return sizeInPixels.width(); }
  virtual int height() { return sizeInPixels.height(); }

  JobId getId() { return id; }

  /** Returns the amount of memory used by this pixmap */
  unsigned int memory();

private:
  // Apply the image transformations of the accessibility viewmodes, and rotation to _image.
  void transformImage();

  QPixmap _rotatedPixmap;

  int currentRotation;
  int currentRotationA;

  QImage _image;

  QPixmap pagePixmap;

  QSize sizeInPixels;

  JobId id;
};

#endif
