/* This file is part of the KDE libraries
    Copyright (c) 2007 David Faure <faure@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <config.h>
#include <kdefakes.h>
#include "kmimefileparsertest.h"
#include "kmimefileparsertest.moc"
#include <qtest_kde.h>
#include "kmimefileparser.h"
#include <kmimetypefactory.h>
#include <ksycoca.h>
#include <kstandarddirs.h>

QTEST_KDEMAIN( KMimeFileParserTest, NoGUI )

// We need a factory that returns the same KMimeType::Ptr every time it's asked for a given mimetype.
// Otherwise the calls to addPattern by KMimeFileParser have no effect that we can test from here.
class FakeMimeTypeFactory : public KMimeTypeFactory
{
public:
    FakeMimeTypeFactory() : KMimeTypeFactory() {}

    virtual KMimeType::Ptr findMimeTypeByName(const QString &_name, KMimeType::FindByNameOption options = KMimeType::DontResolveAlias) {
        Q_UNUSED(options); // not useful here - but this means, don't test anything that relies on aliases ;)
        KMimeType::Ptr result = m_cache.value(_name);
        if (!result) {
            result = KMimeTypeFactory::findMimeTypeByName(_name, options);
            m_cache.insert(_name, result);
        }
        return result;
    }
private:
    QMap<QString, KMimeType::Ptr> m_cache;
};

void KMimeFileParserTest::initTestCase()
{
    if ( !KSycoca::isAvailable() ) {
        // Create ksycoca4 in ~/.kde-unit-test
        QProcess::execute( KGlobal::dirs()->findExe(KBUILDSYCOCA_EXENAME), QStringList() << "--noincremental" );
    }
    // Create factory on the heap and don't delete it.
    // It registers to KSycoca, which deletes it at end of program execution.
    m_factory = new FakeMimeTypeFactory;
}

void KMimeFileParserTest::testParseGlobFile()
{
    KMimeFileParser parser(m_factory);

    const QString ext1 = "*.kmimefileparserunittest";
    const QString ext2 = "*.kmimefileparserunittest2";

    KMimeType::Ptr textPlain = KMimeType::mimeType("text/plain");
    QVERIFY(textPlain);
    QVERIFY(!textPlain->patterns().contains(ext1));
    QVERIFY(!textPlain->patterns().contains(ext2));

    QByteArray testFile = "# Test data\ntext/plain:*.kmimefileparserunittest\ntext/plain:*.kmimefileparserunittest2";
    QBuffer buf(&testFile);
    parser.parseGlobFile(&buf, "testFile");

    QVERIFY(textPlain->patterns().contains(ext1));
    QVERIFY(textPlain->patterns().contains(ext2));

}

