/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <kdeprint@swing.be>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#include "kmconfiglpr.h"
#include "lprsettings.h"

#include <QtGui/QComboBox>
#include <QtGui/QLabel>
#include <QtGui/QLayout>
#include <QtGui/QGroupBox>
#include <klocale.h>
#include <kconfig.h>
#include <kconfiggroup.h>

KMConfigLpr::KMConfigLpr(QWidget *parent)
    : KMConfigPage(parent)
{
	setPageName(i18n("Spooler"));
	setPageHeader(i18n("Spooler Settings"));
	setPagePixmap("gear");

	QGroupBox	*m_modebox = new QGroupBox(i18n("Spooler"), this);
	QVBoxLayout *layout = new QVBoxLayout(m_modebox);

	m_mode = new QComboBox(m_modebox);
	m_mode->addItem("LPR (BSD compatible)");
	m_mode->addItem("LPRng");

	layout->addWidget( m_mode );

	QVBoxLayout	*l0 = new QVBoxLayout(this);
	l0->setMargin(5);
	l0->setSpacing(10);
	l0->addWidget(m_modebox);
	l0->addStretch(1);
}

void KMConfigLpr::loadConfig(KConfig*)
{
	m_mode->setCurrentIndex(LprSettings::self()->mode());
}

void KMConfigLpr::saveConfig(KConfig *conf)
{
	LprSettings::self()->setMode((LprSettings::Mode)(m_mode->currentIndex()));

	QString	modestr;
	switch (m_mode->currentIndex())
	{
		default:
		case 0: modestr = "LPR"; break;
		case 1: modestr = "LPRng"; break;
	}
	KConfigGroup cg( conf, "LPR");
	cg.writeEntry("Mode", modestr);
}
