/*  This file is part of the KDE project
    Copyright (C) 2007 Kevin Ottens <ervin@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

#ifndef SOLID_IFACES_STORAGEACCESS_H
#define SOLID_IFACES_STORAGEACCESS_H

#include <solid/ifaces/deviceinterface.h>
#include <solid/storageaccess.h>

namespace Solid
{
namespace Ifaces
{
    /**
     * This device interface is available on volume devices.
     *
     * A volume is anything that can contain data (partition, optical disc,
     * memory card). It's a particular kind of block device.
     */
    class StorageAccess : virtual public DeviceInterface
    {
    public:
        /**
         * Destroys a StorageVolume object.
         */
        virtual ~StorageAccess();


        /**
         * Indicates if this volume is mounted.
         *
         * @return true if the volume is mounted
         */
        virtual bool isAccessible() const = 0;

        /**
         * Retrieves the absolute path of this volume mountpoint.
         *
         * @return the absolute path to the mount point if the volume is
         * mounted, QString() otherwise
         */
        virtual QString filePath() const = 0;

        /**
         * Mounts the volume.
         *
         * @return the job handling the operation
         */
        virtual bool setup() = 0;

        /**
         * Unmounts the volume.
         *
         * @return the job handling the operation
         */
        virtual bool teardown() = 0;

    protected:
    //Q_SIGNALS:
        /**
         * This signal is emitted when the mount state of this device
         * has changed.
         *
         * @param newState true if the volume is mounted, false otherwise
         */
        virtual void accessibilityChanged(bool accessible) = 0;

        /**
         * This signal is emitted when the mount state of this device
         * has changed.
         *
         * @param newState true if the volume is mounted, false otherwise
         */
        virtual void setupDone(Solid::ErrorType error, QVariant resultData) = 0;

        /**
         * This signal is emitted when the mount state of this device
         * has changed.
         *
         * @param newState true if the volume is mounted, false otherwise
         */
        virtual void teardownDone(Solid::ErrorType error, QVariant resultData) = 0;
    };
}
}

Q_DECLARE_INTERFACE(Solid::Ifaces::StorageAccess, "org.kde.Solid.Ifaces.StorageAccess/0.1")

#endif
