# - Try to find the CD Paranoia libraries
# Once done this will define
#
#  CDPARANOIA_FOUND       - system has cdparanoia
#  CDPARANOIA_INCLUDE_DIR - the cdparanoia include directory
#  CDPARANOIA_LIBRARIES   - Link these to use cdparanoia
#

# Copyright (c) 2006, Richard Laerkaeng, <richard@goteborg.utfors.se>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

FIND_PROGRAM(CDPARANOIA_EXECUTABLE NAMES cdparanoia 
# these paths should be searched automatically by cmake, so no need to specify them explicitely
# but I'm not too sure about the /sbin ones, Alex
#    PATHS /bin /sbin /usr/bin /usr/sbin /usr/local/bin /usr/local/sbin
)

FIND_PATH(CDPARANOIA_INCLUDE_DIR cdda_interface.h
# /usr/include and /usr/local/include are also searched automatically, Alex
#    /usr/include /usr/local/include
)

FIND_LIBRARY(CDPARANOIA_LIBRARY NAMES cdda_paranoia)
FIND_LIBRARY(CDPARANOIA_IF_LIBRARY NAMES cdda_interface)


IF (CDPARANOIA_LIBRARY AND CDPARANOIA_IF_LIBRARY  AND CDPARANOIA_INCLUDE_DIR)
    SET(CDPARANOIA_LIBRARIES ${CDPARANOIA_LIBRARY} ${CDPARANOIA_IF_LIBRARY}  "-lm")
    SET(CDPARANOIA_FOUND TRUE)

    IF (NOT Cdparanoia_FIND_QUIETLY)
      MESSAGE(STATUS "Found cdparanoia: ${CDPARANOIA_LIBRARIES}")
    ENDIF(NOT Cdparanoia_FIND_QUIETLY)

ELSE  (CDPARANOIA_LIBRARY AND CDPARANOIA_IF_LIBRARY  AND CDPARANOIA_INCLUDE_DIR)

    SET(CDPARANOIA_FOUND FALSE)
    IF (Cdparanoia_FIND_REQUIRED)
        MESSAGE(FATAL_ERROR "Could not find cdparanoia")
    ENDIF (Cdparanoia_FIND_REQUIRED)
    IF (NOT Cdparanoia_FIND_QUIETLY)
       MESSAGE(STATUS "Did not find cdparanoia")
    ENDIF(NOT Cdparanoia_FIND_QUIETLY)
ENDIF (CDPARANOIA_LIBRARY AND CDPARANOIA_IF_LIBRARY  AND CDPARANOIA_INCLUDE_DIR)


