/* This file is part of Noatun

  This file was created on 2005-04-29

  Copyright 2005-2007 by Stefan Gehn <mETz81@web.de>
  Copyright 2006 by Charles Samuels <charles@kde.org>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "noatun/config.h"

#include <kcomponentdata.h>
#include <kconfigskeleton.h>
#include <kdebug.h>

namespace Noatun
{

class ConfigPrivate
{
public:
	KConfigSkeleton *skel;

	// configuration settings
	bool             oneInstance;
	QString          downloadPath;
	bool             clearOnOpen;
	QString          titleFormat;
	bool             useHardwareMixer;
};


// -----------------------------------------------------------------------------


Config::Config(const KComponentData &componentData) : d(new ConfigPrivate())
{
	kDebug(66666) << k_funcinfo << endl;
	d->skel = new KConfigSkeleton(componentData.config());

	d->skel->setCurrentGroup("General");
	d->skel->addItemBool("OneInstance"     , d->oneInstance     , true);
	d->skel->addItemPath("DownloadPath"    , d->downloadPath    , "$HOME");
	d->skel->addItemBool("ClearOnOpen"     , d->clearOnOpen     , false);
	d->skel->addItemString("TitleFormat"   , d->titleFormat     , "$(\"[\"author\"] - \")$(title)$(\" (\"bitrate\"kbps)\")");
	d->skel->addItemBool("UseHardwareMixer", d->useHardwareMixer, false);

	d->skel->readConfig();
}

Config::~Config()
{
	kDebug(66666) << k_funcinfo << endl;
	writeConfig();
	delete d->skel;
	delete d;
}

void Config::writeConfig()
{
	kDebug(66666) << k_funcinfo << endl;
	d->skel->writeConfig();
}

void Config::readConfig()
{
	kDebug(66666) << k_funcinfo << endl;
	d->skel->readConfig();
}

void Config::setDefaults()
{
	kDebug(66666) << k_funcinfo << endl;
	d->skel->setDefaults();
}

bool Config::oneInstance() const
{
	return d->oneInstance;
}
void Config::setOneInstance(bool b)
{
	d->oneInstance = b;
}

QString Config::downloadPath() const
{
	return d->downloadPath;
}
void Config::setDownloadPath(const QString &p)
{
	d->downloadPath = p;
}

bool Config::clearOnOpen() const
{
	return d->clearOnOpen;
}
void Config::setClearOnOpen(bool b)
{
	d->clearOnOpen = b;
}

QString Config::titleFormat() const
{
	return d->titleFormat;
}
void Config::setTitleFormat(const QString &s)
{
	d->titleFormat = s;
}

bool Config::useHardwareMixer() const
{
	return d->useHardwareMixer;
}
void Config::setUseHardwareMixer(bool b)
{
	d->useHardwareMixer = b;
}

} // namespace Noatun
