/* This file is part of Noatun

  Copyright 2000-2006 by Charles Samuels <charles@kde.org>
  Copyright 2001-2007 by Stefan Gehn <mETz81@web.de>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef N_CONTROLS_H
#define N_CONTROLS_H

#include <qslider.h>
#include <kaction.h>

#include <noatun_export.h>

namespace Noatun
{

/**
 * A slider that can be moved around while being
 * changed internally
 *
 * @short Special QSlider based class suitable for time sliders
 * @author Charles Samuels
 * @version 2.3
 **/
class NOATUN_EXPORT L33tSlider : public QSlider
{
Q_OBJECT
public:
	explicit L33tSlider(QWidget *parent);
	L33tSlider(Qt::Orientation, QWidget *parent);

	bool currentlyPressed() const;

Q_SIGNALS:
	/**
	 * emitted only when the user changes the value manually
	 **/
	void userChanged(int value);

public Q_SLOTS:
	void setValue(int);

protected:
	virtual void keyPressEvent(QKeyEvent *);
	virtual void mousePressEvent(QMouseEvent*);
	virtual void mouseReleaseEvent(QMouseEvent*);
	virtual void wheelEvent(QWheelEvent *);

private:
	bool pressed;
};

/**
 * @short A slider for your toolbar
 * @author Charles Samuels
 * @version 2.3
 * @todo Test in a toolbar, KDE4 port is untested so far
 **/
class NOATUN_EXPORT SliderAction : public KAction
{
Q_OBJECT
public:
	SliderAction(const QString& text, QObject* parent);

	int value() const;

Q_SIGNALS:
	/**
	 * @see L33tSlider::userChanged(int);
	 **/
	void userChanged(int value);

public Q_SLOTS:
	void setValue(int);

protected:
	virtual QWidget *createWidget(QWidget* _parent);
}; // class SliderAction

} // namespace Noatun
#endif // N_CONTROLS_H
