/* This file is part of Noatun

  This file was created on 2005-05-23

  Copyright 2005-2007 by Stefan Gehn <mETz81@web.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/
#ifndef N_AKODE_H
#define N_AKODE_H

#include <noatun/plugin.h>
#include <noatun/plugininterfaces.h>

#include <akode/player.h>
#include <qcoreevent.h>

using namespace Noatun;

/**
 * @author Stefan Gehn
 * @todo Add an Equalizer as soon as libnoatun has an effects API
 **/
class AKodePlugin : public Plugin, public EngineInterface, public aKode::Player::Manager
{
Q_OBJECT
public:
	AKodePlugin(const KComponentData &instance, Global *parent, const char* name);
	virtual ~AKodePlugin();

	virtual void init();
	virtual void requestUnload();
	Interface *getInterface(const QString &interface);

	virtual Player::State state() const;
	virtual int position() const;
	virtual int length() const;
	virtual QStringList mimeTypes() const;
	virtual unsigned int softwareVolume() const;
	virtual void setSoftwareVolume(unsigned int percent);
	virtual bool play(const KUrl &url);
	virtual void pause();
	virtual void stop();
	virtual void setPosition(int msec);

	// Reimplemented from aKode::Manager
	virtual void stateChangeEvent(aKode::Player::State newState);
	virtual void eofEvent();
	virtual void errorEvent();

protected:
	static Noatun::Player::State convertState(aKode::Player::State);
	static AKodePlugin* self() { return s_self; }
	virtual void customEvent(QEvent *e);

private:
	aKode::Player *mPlayer;
	static AKodePlugin* s_self;
};

#endif
