#include <noatun/engine.h>
#include <noatun/player.h>
#include <noatun/global.h>
#include <noatun/playlist.h>
//#include <noatun/pluginloader.h>

#include <qlayout.h>

#include <kapplication.h>
#include <kgenericfactory.h>
#include <kglobalaccel.h>
#include <kkeydialog.h>
#include <klocale.h>
#include <qclipboard.h>

#include "keyz.h"


K_EXPORT_COMPONENT_FACTORY(noatun_keyz, Noatun::PluginFactory<Keyz>("noatun_keyz"))


KGlobalAccel * Keyz::s_accel = 0L;

Keyz::Keyz(const KComponentData &inst, Noatun::Global *glob, const char* name)
	: Plugin(inst, glob, name), preMuteVol(0)
{
	Noatun::Player *player = glob->player();

	if ( !s_accel )
	{
		s_accel = new KGlobalAccel( this, "noatunglobalaccel" );
		s_accel->insert( "PlayPause", i18n("Play/Pause"), QString::null,
		                CTRL+ALT+Key_P, KKey::QtWIN+CTRL+Key_P,
		                player, SLOT( playpause() ));
		s_accel->insert( "Stop", i18n("Stop Playing"), QString::null,
		                CTRL+ALT+Key_S, KKey::QtWIN+CTRL+Key_S,
		                player, SLOT( stop() ));
		s_accel->insert( "Back", i18n("Back"), QString::null,
		                CTRL+ALT+Key_Left, KKey::QtWIN+CTRL+Key_Left,
		                player, SLOT( back() ));
		s_accel->insert( "Forward", i18n("Forward"), QString::null,
		                CTRL+ALT+Key_Right, KKey::QtWIN+CTRL+Key_Right,
		                player, SLOT( forward() ));
		s_accel->insert( "Playlist", i18n("Show/Hide Playlist"), QString::null,
		                CTRL+ALT+Key_L, KKey::QtWIN+CTRL+Key_L,
		                player, SLOT( toggleListView() ));
		s_accel->insert( "OpenFile", i18n("Open File to Play"), QString::null,
		                CTRL+ALT+Key_O, KKey::QtWIN+CTRL+Key_O,
		                global(), SLOT( fileOpen() ));
		s_accel->insert( "Effects", i18n("Effects Configuration"), QString::null,
		                CTRL+ALT+Key_E, KKey::QtWIN+CTRL+Key_E,
		                global(), SLOT( effectView() ));
		s_accel->insert( "Preferences", i18n("Preferences"), QString::null,
		                CTRL+ALT+Key_F, KKey::QtWIN+CTRL+Key_F,
		                global(), SLOT( preferences() ));
		s_accel->insert( "VolumeUp", i18n("Volume Up"), QString::null,
		                CTRL+ALT+SHIFT+Key_Up, KKey::QtWIN+CTRL+SHIFT+Key_Up,
		                this, SLOT( slotVolumeUp() ));
		s_accel->insert( "VolumeDown", i18n("Volume Down"), QString::null,
		                CTRL+ALT+SHIFT+Key_Down, KKey::QtWIN+CTRL+SHIFT+Key_Down,
		                this, SLOT( slotVolumeDown() ));
		s_accel->insert( "Mute", i18n("Mute"), QString::null,
		                CTRL+ALT+Key_M, KKey::QtWIN+CTRL+Key_M,
		                this, SLOT( slotMute() ));
		s_accel->insert( "SeekForward", i18n("Seek Forward"), QString::null,
		                CTRL+ALT+SHIFT+Key_Right, KKey::QtWIN+CTRL+SHIFT+Key_Right,
		                this, SLOT( slotForward() ));
		s_accel->insert( "SeekBackward", i18n("Seek Backward"), QString::null,
		                CTRL+ALT+SHIFT+Key_Left, KKey::QtWIN+CTRL+SHIFT+Key_Left,
		                this, SLOT( slotBackward() ));
		s_accel->insert( "NextSection", i18n("Next Section"), QString::null,
		                0, 0,
		                this, SLOT( slotNextSection() ));
		s_accel->insert( "PrevSection", i18n("Previous Section"), QString::null,
		                0, 0,
		                this, SLOT( slotPrevSection() ));
		s_accel->insert( "CopyTitle", i18n("Copy Song Title to Clipboard"), QString::null,
		                CTRL+ALT+Key_C, KKey::QtWIN+CTRL+Key_C,
		                this, SLOT( slotCopyTitle() ));

		s_accel->insert( "ToggleGUI", i18n("Show/Hide Main Window"), QString::null,
		                CTRL+ALT+Key_W, KKey::QtWIN+CTRL+Key_W,
		                global(), SLOT( toggleInterfaces() ));

		s_accel->readSettings();
		s_accel->updateConnections();
	}

	new KeyzPrefs(this);
}

Keyz::~Keyz()
{
	delete s_accel;
	s_accel = 0;
}

void Keyz::slotVolumeUp()
{
	int vol = global()->player()->volume();
	if ( vol >= 100 )
		return;

	global()->player()->setVolume( vol + 4 );
}

void Keyz::slotVolumeDown()
{
	int vol = global()->player()->volume();
	if ( vol <= 0 )
		return;

	global()->player()->setVolume( vol - 4 );
}

void Keyz::slotForward()
{
	Noatun::Player *player = global()->player();
	player->seek( QMIN(player->length(), player->position() + 3000) ); // + 3 seconds
}

void Keyz::slotBackward()
{
	Noatun::Player *player = global()->player();
	player->seek( QMAX( 0, player->position() - 3000 )); // - 3 seconds
}

void Keyz::slotNextSection()
{
	Noatun::Playlist *list = global()->playlist();
	if ( list )
	{
// TODO
//		Noatun::PlaylistItem item = list->nextSection();
//		if ( !item.isNull() )
//			global()->player()->play( item );
	}
}

void Keyz::slotPrevSection()
{
	Noatun::Playlist *list = global()->playlist();
	if ( list )
	{
//		TODO
//		Noatun::PlaylistItem item = list->previousSection();
//		if ( !item.isNull() )
//			global()->player()->play( item );
	}
}

void Keyz::slotCopyTitle()
{
	if (global()->player()->current())
		kapp->clipboard()->setText(global()->player()->currentTitle());
}


void Keyz::slotMute()
{
	int vol = global()->player()->volume();

	if ( vol <= 0 ) // already muted
	{
		vol = preMuteVol;
	}
	else // we should mute
	{
		preMuteVol = vol;
		vol = 0;
	}

	global()->player()->setVolume( vol );
}

///////////////////////////////////////////////////////////////////

KeyzPrefs::KeyzPrefs( Noatun::Plugin *plug )
	: PreferencesPage(
			plug, i18n("Shortcuts (Keyz)"), i18n("Shortcut Configuration"), "key_bindings"
		)
{
	QVBoxLayout *layout = new QVBoxLayout( frame() );
	m_chooser = new KKeyChooser( Keyz::accel(), frame() );
	layout->addWidget( m_chooser );
}
	
void KeyzPrefs::load()
{

}

void KeyzPrefs::defaults()
{

}

void KeyzPrefs::save()
{
	m_chooser->commitChanges();
	Keyz::accel()->updateConnections();
	Keyz::accel()->writeSettings();
}

#include "keyz.moc"
