/*
  Milk Chocolate userinterface for Noatun

  Copyright 1999 Charles Samuels <charles@kde.org>
*/
#ifndef USERINTERFACE_H
#define USERINTERFACE_H

#include <noatun/plugin.h>
#include <noatun/plugininterfaces.h>
#include <noatun/nmainwindow.h>

class QPushButton;

namespace Noatun
{
class Player;
class L33tSlider;
class PlaylistItem;
}

using namespace Noatun;


class MilkChocolate : public NMainWindow
{
	Q_OBJECT
	Global *nInstance;

public:
	MilkChocolate(Plugin *pl, Global *gl);
	virtual ~MilkChocolate();
	void load(const QString& url);

protected:
	virtual void dragEnterEvent(QDragEnterEvent *event);
	virtual void dropEvent(QDropEvent *event);
	virtual bool eventFilter(QObject*, QEvent*);
	virtual void wheelEvent(QWheelEvent *e);

public Q_SLOTS:
	void slotPlaying();
	void slotStopped();
	void slotPaused();
	void playlistShown();
	void playlistHidden();

	void updatePositionText(int second);
	void setPlayerPosition(int second);
	void setPlayerVolume(int vol);
	void updateVolume(unsigned int);
	void updateSeekSlider(int);
	void currentItemChanged(const PlaylistItem &);

private Q_SLOTS:
	void changeStatusbar(const QString& text, const QString &text2 = QString::null);

private:
	QPushButton *mBack;
	QPushButton *mStop;
	QPushButton *mPlay;
	QPushButton *mForward;
	QPushButton *mPlaylist;
	//QPushButton *mLoop;

	L33tSlider *mSeekSlider;
	L33tSlider *mVolumeSlider;
};


// -----------------------------------------------------------------------------


class MCPlugin : public Plugin, public FrontendInterface
{
	MilkChocolate *ui;

public:
	MCPlugin(const KComponentData &inst, Global *glob, const char* name);
	Interface *getInterface(const QString &n);
	KMainWindow *mainWindow();
};


#endif
