/***************************************************************************
                     A simple databse-driven playlist for Noatun
                    ---------------------------------------------
    begin                : 27.05.2005
    copyright            : (C) 2005 by Stefan Gehn
    email                : Stefan Gehn <mETz81@web.de>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SIMPLEDB_H
#define SIMPLEDB_H

#include <qobject.h>
#include <qmap.h>
#include <qvaluelist.h>
#include <kurl.h>
#include <qvariant.h>

#include <noatun/playlist.h>

class QSqlDatabase;

/// data container for operating on db-entries
class DBItem
{
public:
	DBItem();
	DBItem(const DBItem &o);
	bool isNull() const;

	int id;
	KURL url;
	int length;
	Noatun::PropertyMap properties;
	int next;
};



/// DB backend
class SimpleDB : public QObject
{
Q_OBJECT
public:
	explicit SimpleDB(QObject *parent);
	~SimpleDB();

	int getFirstItemId() const;
	int getNextItemId(int currentItemId) const;
	bool insertItem(DBItem &item, int insertAfterId);
	bool deleteItem(int id);
	QMap<int, DBItem> getOrderedItems() const;
	DBItem getItem(int id, bool withProps = true) const;
	DBItem getItemBefore(int id, bool withProps = true) const;

	bool moveItem(int itemId, int nearId, bool before);
	/// Sets fields inside item, returns true if operation succeeded
	bool setUrl(int id, const KURL &url);
	bool setLength(int id, int length);

	bool setProperty(int id, const QString &key, const QString &val);
	bool setProperties(int id, const Noatun::PropertyMap &properties);
	bool deleteProperty(int id, const QString &key);

Q_SIGNALS:
	void itemInserted(const DBItem &);
	void itemDeleted(int id);
	void itemUpdated(int id);
	void itemUpdatedLength(int id, int newLen);
	void itemUpdatedPosition(int id, int oldNext, int newNext);

private:
	QString setup();
	bool createTableIfMissing(const QString &tablename, const QString &fields);
	bool createTriggerIfMissing(const QString &triggername, const QString &code);
	bool createIndexOn(const QString &tablename, const QString &columnname);
	int getNextId(const QString &table, const QString &field) const;
	bool updateField(int id, const QString &field, const QVariant &val);
	bool replaceNext(int oldNext, int newNext);
	bool setNext(DBItem &item, int newNextId);
	int getLastItemIdInList() const;
	DBItem getItemByField(const QString &field, int id, bool withProps) const;
	bool setProp(int id, const QString &key, const QString &val); /// backend-function for both setProperty and setProperties
	Noatun::PropertyMap getProperties(int id) const;

private:
	QSqlDatabase *db;
}; // END class SimpleDB

#endif
