//
// Copyright 2004 Stefan Gehn <metz AT gehn DOT net>
// Copyright 1999 Neil Stevens <multivac@fcmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include "kitsystemtray.h"
#include "yhconfig.h"

#include "noatun/player.h"
#include "noatun/plugin.h"
#include "noatun/global.h"
#include "noatun/stdaction.h"

#include <qdragobject.h>
#include <kpopupmenu.h>
#include <kxmlguiclient.h>
#include <kaction.h>
#include <kurldrag.h>

#include <kdebug.h>

KitSystemTray::KitSystemTray(Noatun::Plugin *plugin, QWidget *parent, const char *name)
	: KSystemTray(parent, name), mPlugin(plugin)
{
	kDebug(66666) << k_funcinfo << endl;
	setAcceptDrops(true);

	KPopupMenu *menu = contextMenu();
	plugin->action("player_back")->plug(menu);
	plugin->action("player_stop")->plug(menu);
	plugin->action("player_playpause")->plug(menu);
	plugin->action("player_forward")->plug(menu);
	plugin->action("player_loopstyle")->plug(menu);
	menu->insertSeparator(); // ---------------
	plugin->action("view_playlist")->plug(menu);
	plugin->action("view_effects")->plug(menu);
	plugin->action("view_equalizer")->plug(menu);
	menu->insertSeparator(); // --------------
	plugin->action("options_configure")->plug(menu);
	menu->insertSeparator(); // --------------
	// Minimize action defined by KSystemTray
	if (KAction *act = actionCollection()->action("minimizeRestore"))
		act->plug(menu);
	plugin->action("file_quit")->plug(menu);
}


KitSystemTray::~KitSystemTray()
{
	kDebug(66666) << k_funcinfo << endl;
}


void KitSystemTray::showEvent(QShowEvent *)
{
	// NOTE: reimplemented to keep KSystemTray from adding
	// duplicate "minimizeRestore" and "quit" actions
}


void KitSystemTray::mousePressEvent(QMouseEvent *event)
{
	switch(event->button())
	{
		case MidButton:
			if (YHConfig::self()->middleMouseAction() == YHConfig::HideShowPlaylist)
				mPlugin->global()->playlist()->toggleList();
			else // play or pause
				mPlugin->global()->player()->playpause();
			break;
		default: // left and right button are handled by KSystemTray
			KSystemTray::mousePressEvent(event);
			break;
	}
}


void KitSystemTray::dragEnterEvent(QDragEnterEvent * event)
{
	event->accept(KURLDrag::canDecode(event)); // accept uri drops only
}


void KitSystemTray::dropEvent(QDropEvent * event)
{
	KURL::List uris;
	if (KURLDrag::decode(event, uris))
		mPlugin->global()->playlist()->addFile(uris);
}


void KitSystemTray::wheelEvent(QWheelEvent *event)
{
	YHConfig *c = YHConfig::self();

	int action = 0;
	if (event->state() & Qt::ShiftButton)
		action = c->mouseWheelAction(YHConfig::ShiftModifier);
	else if (event->state() & Qt::ControlButton)
		action = c->mouseWheelAction(YHConfig::CtrlModifier);
	else if (event->state() & Qt::AltButton)
		action = c->mouseWheelAction(YHConfig::AltModifier);
	else
		action = c->mouseWheelAction(YHConfig::NoModifier);

	Noatun::Player *pl = mPlugin->global()->player();
	if (!pl)
		return;

	switch(action)
	{
		case (YHConfig::ChangeVolume):
			pl->setVolume(pl->volume() + event->delta() / 24);
			break;

		case (YHConfig::ChangeTrack):
			if (event->delta() > 0)
				pl->next();
			else
				pl->previous();
			break;
	}
}

#include "kitsystemtray.moc"
