/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamertypefindelement.h"
#include "../qbtgstreamercallbackmanager.h"
#include "../qbtgstreamerdatapointer.h"

#include <QtDebug>

QbtGStreamerTypeFindElement* QbtGStreamerTypeFindElement::s_instance;

QbtGStreamerTypeFindElement::QbtGStreamerTypeFindElement() : QbtGStreamerElement()
{
    s_instance = this;
}

QbtGStreamerTypeFindElement::QbtGStreamerTypeFindElement(const QbtGStreamerTypeFindElement& obj) : QbtGStreamerElement()
{
    *this = obj;
}

QbtGStreamerTypeFindElement& QbtGStreamerTypeFindElement::operator= (const QbtGStreamerTypeFindElement& obj)
{
    *this = obj;
    return *this;
}

QbtGStreamerTypeFindElement::QbtGStreamerTypeFindElement(QbtGStreamerElement* obj) : QbtGStreamerElement()
{
    setGstElement(obj->gstElement());

    QbtGStreamerCallbackManager::Instance()->elements.removeAll(obj);
    QbtGStreamerCallbackManager::Instance()->elements.append(this);

    //qDebug() << "Copy constructor, m_element = " << m_element;
    if(gstElement())
        g_signal_connect(GST_OBJECT(gstElement()), "have-type", G_CALLBACK(have_type), s_instance);
}

QbtGStreamerTypeFindElement::~QbtGStreamerTypeFindElement()
{
}

/*QbtGStreamerCaps* QbtGStreamerTypeFindElement::caps()
{
}*/

void QbtGStreamerTypeFindElement::have_type(GstElement *typefind, guint probability, GstCaps *caps, gpointer user_data)
{
    qDebug() << "have_type callback called!";

    QbtGStreamerCapabilities *btCaps;
    QbtGStreamerDataPointer *btData;

    foreach(QbtGStreamerElement* e, QbtGStreamerCallbackManager::Instance()->elements) {
        if(typefind == e->gstElement()) {
            btCaps = new QbtGStreamerCapabilities;
            btCaps->setGstCaps(caps);
            btData = new QbtGStreamerDataPointer;
            btData->setGPointer(user_data);
            QbtGStreamerTypeFindElement* e2 = static_cast<QbtGStreamerTypeFindElement*>(e);
            emit e2->haveType(e2, probability, btCaps, btData);
        }
    }
}

#include "qbtgstreamertypefindelement.moc"

