/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamermessage.h"

QbtGStreamerMessage::QbtGStreamerMessage()
{
}

QbtGStreamerMessageType QbtGStreamerMessage::type()
{
    return getType(m_message->type);
}

qint64 QbtGStreamerMessage::timestamp()
{
    return m_message->timestamp;
}

QbtGStreamerObject *QbtGStreamerMessage::sourceObject()
{
    QbtGStreamerObject *obj = new QbtGStreamerObject;

    obj->setGstObject(m_message->src);

    return obj;
}

QbtGStreamerStructure *QbtGStreamerMessage::structure()
{
    QbtGStreamerStructure *str = new QbtGStreamerStructure;

    str->setGstStructure(m_message->structure);

    return str;
}

/*const gchar* gst_message_type_get_name(GstMessageType type);*/
QString QbtGStreamerMessage::typeName(QbtGStreamerMessageType type)
{
    QString str(gst_message_type_get_name(getGstMessageType(type)));
    return str;
}

/*void gst_message_parse_error(GstMessage *message, GError **gerror, gchar **debug);*/
QbtGStreamerError *QbtGStreamerMessage::error(QString& debugMessage)
{
    GError *error = 0;
    char *debug_string;

    gst_message_parse_error(m_message, &error, &debug_string);

    debugMessage = QString(debug_string);

    QbtGStreamerError *btError = new QbtGStreamerError;
    btError->setGError(error);

    return btError;
}

/*void QbtGStreamerMessage::stateChanged(GstState *oldstate, GstState *newstate, GstState *pending)
{ 
    gst_message_parse_state_changed(m_message, oldstate, newstate, pending); 
}*/

void QbtGStreamerMessage::setGstMessage(GstMessage *message)
{
    m_message = message;
}

GstMessage *QbtGStreamerMessage::gstMessage()
{
    return m_message;
}

QbtGStreamerMessageType QbtGStreamerMessage::getType(GstMessageType type)
{
    switch(type)
    {
        case GST_MESSAGE_UNKNOWN:
            return QbtGStreamerMessageUnknown;
        case GST_MESSAGE_EOS:
            return QbtGStreamerMessageEos;
        case GST_MESSAGE_ERROR:
            return QbtGStreamerMessageError;
        case GST_MESSAGE_WARNING:
            return QbtGStreamerMessageWarning;
        case GST_MESSAGE_INFO:
            return QbtGStreamerMessageInfo;
        case GST_MESSAGE_TAG:
            return QbtGStreamerMessageTag;
        case GST_MESSAGE_BUFFERING:
            return QbtGStreamerMessageBuffering;
        case GST_MESSAGE_STATE_CHANGED:
            return QbtGStreamerMessageStateChanged;
        case GST_MESSAGE_STATE_DIRTY:
            return QbtGStreamerMessageStateDirty;
        case GST_MESSAGE_STEP_DONE:
            return QbtGStreamerMessageStepDone;
        case GST_MESSAGE_CLOCK_PROVIDE:
            return QbtGStreamerMessageClockProvide;
        case GST_MESSAGE_CLOCK_LOST:
            return QbtGStreamerMessageClockLost;
        case GST_MESSAGE_NEW_CLOCK:
            return QbtGStreamerMessageNewClock;
        case GST_MESSAGE_STRUCTURE_CHANGE:
            return QbtGStreamerMessageStructureChange;
        case GST_MESSAGE_STREAM_STATUS:
            return QbtGStreamerMessageStreamStatus;
        case GST_MESSAGE_APPLICATION:
            return QbtGStreamerMessageApplication;
        case GST_MESSAGE_ELEMENT:
            return QbtGStreamerMessageElement;
        case GST_MESSAGE_SEGMENT_START:
            return QbtGStreamerMessageSegmentStart;
        case GST_MESSAGE_SEGMENT_DONE:
            return QbtGStreamerMessageSegmentDone;
        case GST_MESSAGE_DURATION:
            return QbtGStreamerMessageDuration;
        case GST_MESSAGE_ANY:
            return QbtGStreamerMessageAny;
    }

    return QbtGStreamerMessageAny;
}

GstMessageType QbtGStreamerMessage::getGstMessageType(QbtGStreamerMessageType type)
{
    switch(type)
    {
        case QbtGStreamerMessageUnknown:
            return GST_MESSAGE_UNKNOWN;
        case QbtGStreamerMessageEos:
            return GST_MESSAGE_EOS;
        case QbtGStreamerMessageError:
            return GST_MESSAGE_ERROR;
        case QbtGStreamerMessageWarning:
            return GST_MESSAGE_WARNING;
        case QbtGStreamerMessageInfo:
            return GST_MESSAGE_INFO;
        case QbtGStreamerMessageTag:
            return GST_MESSAGE_TAG;
        case QbtGStreamerMessageBuffering:
            return GST_MESSAGE_BUFFERING;
        case QbtGStreamerMessageStateChanged:
            return GST_MESSAGE_STATE_CHANGED;
        case QbtGStreamerMessageStateDirty:
            return GST_MESSAGE_STATE_DIRTY;
        case QbtGStreamerMessageStepDone:
            return GST_MESSAGE_STEP_DONE;
        case QbtGStreamerMessageClockProvide:
            return GST_MESSAGE_CLOCK_PROVIDE;
        case QbtGStreamerMessageClockLost:
            return GST_MESSAGE_CLOCK_LOST;
        case QbtGStreamerMessageNewClock:
            return GST_MESSAGE_NEW_CLOCK;
        case QbtGStreamerMessageStructureChange:
            return GST_MESSAGE_STRUCTURE_CHANGE;
        case QbtGStreamerMessageStreamStatus:
            return GST_MESSAGE_STREAM_STATUS;
        case QbtGStreamerMessageApplication:
            return GST_MESSAGE_APPLICATION;
        case QbtGStreamerMessageElement:
            return GST_MESSAGE_ELEMENT;
        case QbtGStreamerMessageSegmentStart:
            return GST_MESSAGE_SEGMENT_START;
        case QbtGStreamerMessageSegmentDone:
            return GST_MESSAGE_SEGMENT_DONE;
        case QbtGStreamerMessageDuration:
            return GST_MESSAGE_DURATION;
        case QbtGStreamerMessageAny:
            return GST_MESSAGE_ANY;
    }

    return GST_MESSAGE_ANY;
}
