/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERMIXER
#define QBTGSTREAMERMIXER

#include "qbtgstreamerobject.h"
#include "qbtgstreamerpad.h"
#include "qbtgstreamerdatapointer.h"
#include "qbtgstreamerbus.h"
#include "qbtgstreamermixertrack.h"
#include "qbtgstreamer_export.h" 

#include <QList>

#include <gst/gst.h>
#include <gst/interfaces/mixer.h>

class QBTGSTREAMER_EXPORT QbtGStreamerMixer
{
public:
    QbtGStreamerMixer();
    ~QbtGStreamerMixer();

    void setGstMixer(GstMixer *mixer);
    GstMixer *gstMixer();

    QList<QbtGStreamerMixerTrack*> tracks();

private:
    GstMixer *m_mixer;
};

#endif
