/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERMIXERTRACK
#define QBTGSTREAMERMIXERTRACK

#include "qbtgstreamerobject.h"
#include "qbtgstreamerpad.h"
#include "qbtgstreamerdatapointer.h"
#include "qbtgstreamerbus.h"
#include "qbtgstreamer_export.h" 

#include <QObject>
#include <QString>
#include <QtGlobal>

#include <gst/gst.h>
#include <gst/interfaces/mixer.h>

class QBTGSTREAMER_EXPORT QbtGStreamerMixerTrack : public QObject
{
public:
    QbtGStreamerMixerTrack();
    ~QbtGStreamerMixerTrack();

    void setGstMixerTrack(GstMixerTrack *mixerTrack);
    GstMixerTrack *gstMixerTrack();

    uint *flags();
    QString label();
    int maximumVolume();
    int minimumVolume();
    int numberOfChannels();

/*signals:
    void muteToggled();
    void recordToggled();
    void volumeChanged();*/

private:
    GstMixerTrack *m_mixerTrack;
};

#endif
