/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamerpad.h"

QbtGStreamerPad::QbtGStreamerPad()
{
}

QbtGStreamerPad::~QbtGStreamerPad()
{
}

GstPad *QbtGStreamerPad::gstPad()
{
    return m_pad;
}

void QbtGStreamerPad::setGstPad(GstPad *pad)
{
    m_pad = pad;
    m_object = GST_OBJECT(pad);
}

QbtGStreamerPadLinkReturn QbtGStreamerPad::link(QbtGStreamerPad* sink)
{
    return (QbtGStreamerPadLinkReturn)gst_pad_link(m_pad, sink->gstPad());
}

bool QbtGStreamerPad::unlink(QbtGStreamerPad* sink)
{
    return gst_pad_unlink(m_pad, sink->gstPad());
}

bool QbtGStreamerPad::linked()
{
    return gst_pad_is_linked(m_pad);
}

bool QbtGStreamerPad::canLink(QbtGStreamerPad *sink)
{
    return gst_pad_can_link(m_pad, sink->gstPad());
}

QbtGStreamerPad *QbtGStreamerPad::peer()
{
    QbtGStreamerPad *newPad = new QbtGStreamerPad;

    GstPad *newGstPad = gst_pad_get_peer(m_pad);

    newPad->setGstPad(newGstPad);
    return newPad;
}

void QbtGStreamerPad::useFixedCaps()
{
    gst_pad_use_fixed_caps(m_pad);
}

bool QbtGStreamerPad::setActive(bool active)
{
    return gst_pad_set_active(m_pad, active);
}

bool QbtGStreamerPad::active()
{
    return gst_pad_is_active(m_pad);
}

bool QbtGStreamerPad::setBlocked(bool blocked)
{
    return gst_pad_set_blocked(m_pad, blocked);
}

/*gboolean gst_pad_is_blocked(GstPad *pad);*/
bool QbtGStreamerPad::blocked()
{
    return gst_pad_is_blocked(m_pad);
}

QbtGStreamerCapabilities* QbtGStreamerPad::capabilities()
{
    GstCaps* caps = gst_pad_peer_get_caps(m_pad);

    QbtGStreamerCapabilities* btCaps = new QbtGStreamerCapabilities;
    btCaps->setGstCaps(caps);

    return btCaps;
}
