/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERPIPELINE
#define QBTGSTREAMERPIPELINE

#include "qbtgstreamerbin.h"
#include "qbtgstreamerclock.h"
#include "qbtgstreamer_export.h"
#include <gst/gst.h>

#include <QString>

class QBTGSTREAMER_EXPORT QbtGStreamerPipeline : public QbtGStreamerBin
{
public:
    /*GstElement* gst_pipeline_new                (const gchar *name);*/
    QbtGStreamerPipeline(const QString& name);
    ~QbtGStreamerPipeline();

    /*gboolean gst_pipeline_set_clock(GstPipeline *pipeline, GstClock *clock);*/
    bool setClock(QbtGStreamerClock *clock);

    /*GstClock* gst_pipeline_get_clock(GstPipeline *pipeline);*/
    QbtGStreamerClock *clock();

    /*void gst_pipeline_use_clock(GstPipeline *pipeline, GstClock *clock);*/
    void useClock(QbtGStreamerClock *clock);

    /*void gst_pipeline_auto_clock(GstPipeline *pipeline);*/
    void autoClock();

    /*void gst_pipeline_set_auto_flush_bus(GstPipeline *pipeline, gboolean auto_flush);*/
    void setAutoFlushBus(bool autoFlush);

    /*gboolean gst_pipeline_get_auto_flush_bus(GstPipeline *pipeline);*/
    bool autoFlushBus();

    GstPipeline *gstPipeline() {return m_pipeline;}

private:
    GstPipeline *m_pipeline;
};

#if 0



            GstPipeline;
enum        GstPipelineFlags;
GstBus*     gst_pipeline_get_bus            (GstPipeline *pipeline);


void        gst_pipeline_set_new_stream_time
                                            (GstPipeline *pipeline,
                                             GstClockTime time);
GstClockTime gst_pipeline_get_last_stream_time
                                            (GstPipeline *pipeline);

void        gst_pipeline_set_delay          (GstPipeline *pipeline,
                                             GstClockTime delay);
GstClockTime gst_pipeline_get_delay         (GstPipeline *pipeline);
#endif

#endif
