/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#ifndef Phonon_NMM_AUDIODATAOUTPUT_H
#define Phonon_NMM_AUDIODATAOUTPUT_H

#include "abstractaudiooutput.h"
#include <QVector>
#include <phonon/audiodataoutput.h>

namespace Phonon
{
namespace nmm
{

	class AudioDataOutput : public AbstractAudioOutput
	{
		Q_OBJECT
		public:
			AudioDataOutput( QObject* parent );
			~AudioDataOutput();

		public slots:
			Phonon::AudioDataOutput::Format format() const;
			int dataSize() const;
			int sampleRate() const;
			void setFormat( Phonon::AudioDataOutput::Format format );
			void setDataSize( int size );

		signals:
			void dataReady( const QMap<Phonon::AudioDataOutput::Channel, QVector<qint16> >& data );
			void dataReady( const QMap<Phonon::AudioDataOutput::Channel, QVector<float> >& data );
			void endOfMedia( int remainingSamples );

		private:
			Phonon::AudioDataOutput::Format m_format;
			int m_dataSize;
			QVector<float> m_pendingData;
	};
}} //namespace Phonon::nmm

#endif // Phonon_NMM_AUDIODATAOUTPUT_H
// vim: sw=4 ts=4 tw=80 noet
