/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */


#ifndef Phonon_NMM_AUDIOOUTPUT_H
#define Phonon_NMM_AUDIOOUTPUT_H

#include "abstractaudiooutput.h"
#include <nmm/base/EDObject.hpp>
#include <phonon/audiooutputinterface.h>

namespace NMM
{
	class INode;
	class IAudioDevice;
}
namespace Phonon
{
namespace nmm
{
	class Backend;
	class AudioOutput : public AbstractAudioOutput, public AudioOutputInterface
	{
		Q_OBJECT
		Q_INTERFACES( Phonon::AudioOutputInterface );
		public:
			AudioOutput( Backend* backend, QObject* parent );
			~AudioOutput();

			// Attributes Getters:
			float volume() const;
			int outputDevice() const;

			// Attributes Setters:
			void setVolume( float newVolume );
			bool setOutputDevice( int newDevice );

		public:
			NMM::INode* sinkNode( );

		Q_SIGNALS:
			void volumeChanged( float newVolume );
			void endTrack();

		private:
			float m_volume;
			int m_device;
			Backend* m_backend;
			NMM::INode* m_sink;
			NMM::IAudioDevice* m_audioDevice;
			NMM::TEDObject0<AudioOutput> m_endTrackListener;
			NMM::Result endTrackCb();
			//bool m_endTrackCBEnabled;
	};
}} //namespace Phonon::nmm

#endif // Phonon_NMM_AUDIOOUTPUT_H
// vim: sw=4 ts=4 tw=80 noet
