/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#ifndef Phonon_NMM_AUDIOPATH_H
#define Phonon_NMM_AUDIOPATH_H

#include <QObject>
#include <QList>
namespace NMM
{
    class GraphHandler;
	class Branch;
}

namespace Phonon
{
namespace nmm
{
	class AudioEffect;
	class AbstractAudioOutput;

	class AudioPath : public QObject
	{
		Q_OBJECT
		public:
			AudioPath( QObject* parent );
			~AudioPath();

			Q_INVOKABLE bool addOutput( QObject* audioOutput );
			Q_INVOKABLE bool removeOutput( QObject* audioOutput );
			Q_INVOKABLE bool insertEffect( QObject* newEffect, QObject* insertBefore = 0 );
			Q_INVOKABLE bool removeEffect( QObject* effect );

			//nmm specific
			bool insertInto(NMM::GraphHandler* graph);
			int getBranchId();
		
		Q_SIGNALS:
			void endTrack();
		private:
			bool internal_insertInto();
			QList<AudioEffect*> m_effects;
			QList<AbstractAudioOutput*> m_outputs;
			NMM::GraphHandler* m_graphHandler;
			NMM::Branch *m_branch;
	};
}} //namespace Phonon::nmm

#endif // Phonon_NMM_AUDIOPATH_H
// vim: sw=4 ts=4 tw=80 noet
