/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */
#ifndef Phonon_NMM_AVCAPTURECAPTURE_H
#define Phonon_NMM_AVCAPTURECAPTURE_H

#include "abstractmediaproducer.h"

namespace Phonon
{
namespace nmm
{
	class Backend;
	class AvCapture : public AbstractMediaProducer
	{
		Q_OBJECT
		public:
			AvCapture( Backend* backend, QObject* parent );
			~AvCapture();

		public slots:
			int audioCaptureDevice() const;
			void setAudioCaptureDevice( int index );
			int videoCaptureDevice() const;
			void setVideoCaptureDevice( int index );
	};
}} //namespace Phonon::nmm

#endif // Phonon_NMM_AVCAPTURECAPTURE_H
// vim: sw=4 ts=4 tw=80 noet
