/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *               
 * Copyright (C) 2006
 * 		 Vincenzo Di Massa <hawk.it@tiscali.it>
 * 		 
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */
#ifndef Phonon_NMM_BYTESTREAM_H
#define Phonon_NMM_BYTESTREAM_H

#include "abstractmediaproducer.h"
#include <phonon/bytestreaminterface.h>

class QTimer;
namespace NMM 
{ 
	class IByteStream;
};

namespace Phonon
{
namespace nmm
{
	class Backend;
	
	class ByteStream : public AbstractMediaProducer, public ByteStreamInterface
	{
		Q_OBJECT
		Q_INTERFACES( Phonon::ByteStreamInterface )
		public:
			ByteStream( Backend*, QObject* parent );
			~ByteStream();

			Q_INVOKABLE qint64 currentTime() const;
			Q_INVOKABLE qint64 totalTime() const;
			Q_INVOKABLE qint32 aboutToFinishTime() const;
			Q_INVOKABLE qint64 streamSize() const;
			Q_INVOKABLE bool streamSeekable() const;
			Q_INVOKABLE bool isSeekable() const;

			Q_INVOKABLE void setStreamSeekable( bool );
			Q_INVOKABLE void writeData( const QByteArray& data );
			Q_INVOKABLE void setStreamSize( qint64 );
			Q_INVOKABLE void endOfData();
			Q_INVOKABLE void setAboutToFinishTime( qint32 );

			Q_INVOKABLE void play();
			Q_INVOKABLE void pause();
			Q_INVOKABLE void seek( qint64 time );

		public Q_SLOTS:
			void stop();

		Q_SIGNALS:
			virtual void finished();
			void aboutToFinish( qint32 );
			void length( qint64 );
			void needData();
			void enoughData();
			void seekStream( qint64 );

		private Q_SLOTS:
			void consumeStream();

		private:
			void reachStage1();
			qint64 m_aboutToFinishBytes;
			qint64 m_streamSize;
			qint64 m_bufferSize;
			qint64 m_streamPosition;
			bool m_streamSeekable;
			bool m_aboutToFinishEmitted;
			QTimer* m_streamConsumeTimer;
			//NMM Specific
			Backend* m_backend;
			NMM::IByteStream* m_iByteStream;
			bool m_sinkInitDone;
            virtual void setTrackDuration(qint64 duration );
	};
}} //namespace Phonon::nmm

#endif // Phonon_NMM_BYTESTREAM_H
// vim: sw=4 ts=4 tw=80 noet
