/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */ 


//http://www.qtforum.de/forum/viewtopic.php?p=3893&

#include "hostlistdelegate.h"
#include <QComboBox>
#include <QCheckBox>
#include <QSlider>

QWidget* HostListDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
	if ( index.column() == 3 )
	{
		QComboBox *combo = new QComboBox( parent );
		
		//FIXME this should be done dynamically
		combo->addItem("PlaybackNode", QVariant("PlaybackNode"));
		combo->addItem("ALSAPlaybackNode", QVariant("ALSAPlaybackNode"));

		connect( combo, SIGNAL( activated( int ) ), this, SLOT( emitCommitData() ) );
		return combo;
	}
	else if ( index.column() == 4 )
	{
		QComboBox *combo = new QComboBox( parent );
		
		//FIXME this should be done dynamically
		combo->addItem("XDisplayNode", QVariant("XDisplayNode"));
		combo->addItem("GLDisplayNode", QVariant("GLDisplayNode"));

		connect( combo, SIGNAL( activated( int ) ), this, SLOT( emitCommitData() ) );
		return combo;
	}
	else if ( index.column() == 6 )
	{
		QSlider* slider = new QSlider(Qt::Horizontal, parent);
		return slider;
	}
 	else if (index.column() == 1 || index.column() == 2)
 	{
 		QCheckBox* box = new QCheckBox(parent);
 		
		connect( box, SIGNAL( stateChanged( int ) ), this, SLOT( emitCommitData() ) );
 		return box;
 	}
	return QItemDelegate::createEditor( parent, option, index );
}

void HostListDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
{
	QComboBox *combo = qobject_cast<QComboBox *>( editor );
	if ( combo )
	{
		int pos = combo->findText( index.model()->data( index ).toString(), Qt::MatchExactly );
		combo -> setCurrentIndex( pos );
		return;
	}
	else
	{
		QCheckBox *box = qobject_cast<QCheckBox *>( editor );
		if (box)
		{
			if (index.model()->data( index, Qt::EditRole ).toBool())
				box->setState(QCheckBox::On);
			else
				box->setState(QCheckBox::Off);
			return;
		}
	}

	QItemDelegate::setEditorData( editor, index );
	return;
}

void HostListDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
{
	QComboBox *combo = qobject_cast<QComboBox *>( editor );
	if ( combo )
	{
		model->setData( index, combo->currentText() );
	}
	else
	{
		QCheckBox *box = qobject_cast<QCheckBox *>( editor );
		if (box)
		{
			bool val = (box->state() == QCheckBox::On);
			model->setData( index, val );
			return;
		}
	}

	QItemDelegate::setModelData( editor, model, index ); 
	return;
}

void HostListDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
	editor->setGeometry(option.rect);
}

void HostListDelegate::emitCommitData() 
{ 
	emit commitData( qobject_cast<QWidget *>( sender() ) );
}
