/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */ 

#ifndef HOSTLISTITEM_H
#define HOSTLISTITEM_H

#include <QIcon>
#include <QVariant>


#define DEFAULT_AUDIO_SINK "PlaybackNode"
#define DEFAULT_VIDEO_SINK "XDisplayNode"

class HostListItem {
public:
	enum Column
	{
		Hostname = 0,
		Audio,
		Video,
		AudioSink,
		VideoSink,
		AudioStream,
		Volume,
		Status
	};

	HostListItem(bool editable, QString hostname, bool audio, bool video, QString audioSink, QString videoSink, int audioId, int volume = -1, QString status = "UNKNOWN");
	HostListItem(bool editable, QString hostname, QString audioSink, int audioId, int volume = -1, QString status = "UNKNOWN");
	HostListItem(bool editable, QString hostname, QString videoSink, QString status = "UNKNOWN");
	~HostListItem();

	//indirectly used by QTableView
	QVariant getColumn(Column col, int role) const;
	bool setColumn(Column col, const QVariant& val);
	static QString getColumnHeader(int i);
	Qt::ItemFlags getFlags(Column col) const;

	//getters
	QString getHostname();
	bool hasAudio();
	bool hasVideo();
	QString getAudioSink();
	QString getVideoSink();
	int getAudioId();
	bool isAudioModified();
	bool isVideoModified();
	bool isAudioEditable();
	bool isVideoEditable();

	//setters
	void setHostname(QString hostname);
	void enableAudio(bool val);
	void enableVideo(bool val);
	void setAudioSink(QString name);
	void setVideoSink(QString name);
	void setAudioId(int id);
	void setAudioModified();
	void setVideoModified();
	void setAudioEditable(bool val);
	void setVideoEditable(bool val);


	static const int memberCount = 8;


private:
	QString m_hostname;
	bool m_audio;
	bool m_video;
	QString m_audioSink;
	QString m_videoSink;
	int m_audioId;
	int m_volume; 
	QString m_status;

	bool m_modifiedAudio;
	bool m_modifiedVideo;
	bool m_editableAudio;
	bool m_editableVideo;

	QIcon* yes;
	QIcon* no;
	QIcon* info;

	void loadPics();

};

#endif
