/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */ 

#ifndef Phonon_NMM_CONFIGPROXY_H
#define Phonon_NMM_CONFIGPROXY_H

#include <QList>
#include <QStringList>

#include "dcopconfigproxyiface.h"

//nmm stuff
//#include "nmm/base/registry/NodeDescription.hpp"
#include "nmm/base/Event.hpp"
//#include "nmm/base/NMMApplication.hpp"
//#include "nmm/base/ProxyApplication.hpp"
#include "nmm/base/graph/GraphHandler.hpp"
using namespace NMM;


namespace Phonon
{
namespace nmm
{

class KDE_EXPORT ConfigProxy : public QObject, virtual public DCOPConfigProxyIface
{
	Q_OBJECT

	public:
		ConfigProxy(GraphHandler* graphHandler);
		~ConfigProxy();

	virtual bool addBranch(const int streamId, QString& sink_nd);
	virtual bool addRemoteBranch(const int streamId, QString& sink_nd, QString& hostname);
	virtual QStringList getBranch(int id);
	virtual QList<int> getBranchIds();
	virtual bool removeBranch(int id);

	private:
		GraphHandler* m_graphHandler;
};

}}
#endif //Phonon_NMM_CONFIGPROXY_H
// vim: sw=4 ts=4 tw=80 noet
