/* This file is part of Noatun

  Copyright 2004-2007 by Stefan Gehn <mETz81@web.de>
  Copyright 2005-2006 by Charles Samuels <charles@kde.org>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef STDACTION_H
#define STDACTION_H

#include <noatun/noatun_export.h>

#include <kaction.h>
#include <ktoggleaction.h>
#include <kactionmenu.h>

namespace Noatun
{
class Global;
class Playlist;

/**
 * @brief An action starting/stopping noatun playback
 **/
class NOATUN_EXPORT PlayPauseAction : public KAction
{
Q_OBJECT
public:
	PlayPauseAction(Global *glob, QObject *parent, const char *name);
private Q_SLOTS:
	void playing();
	void notplaying();
};


/**
 * @brief An action opening/closing noatun playlist
 **/
class NOATUN_EXPORT PlaylistAction : public KToggleAction
{
Q_OBJECT
public:
	PlaylistAction(Global *glob, QObject *parent, const char *name);
protected Q_SLOTS:
	virtual void slotToggled(bool on);
private Q_SLOTS:
	void slotShown();
	void slotHidden();
private:
	Global *mGlobal;
};


/**
 * @brief An action menu that holds all looping modes
 * @author Stefan Gehn
 */
class NOATUN_EXPORT LoopActionMenu : public KActionMenu
{
Q_OBJECT
public:
	LoopActionMenu(Global *glob, QObject *parent, const char *name);
private Q_SLOTS:
	//void updateLooping(int);
	void loopNoneSelected();
	void loopSongSelected();
	void loopPlaylistSelected();
	void loopRandomSelected();
private:
	KAction *mLoopNone;
	KAction *mLoopSong;
	KAction *mLoopPlaylist;
	KAction *mLoopRandom;
	Global *mGlobal;
};

/**
 * actionmenu that holds all vis-plugins for easier enabling/disabling
 * @author Stefan Gehn
 **/
#if 0
class NOATUN_EXPORT VisActionMenu : public KActionMenu
{
	Q_OBJECT
public:
	VisActionMenu(Global *glob, QObject *parent, const char *name);
private Q_SLOTS:
	void fillPopup();
	void toggleVisPlugin(int);
private:
	QMap<int, QString>mVisPluginMap;
	Global *mGlobal;
};
#endif


/**
 * Holds all noatun related actions
 *
 * @short noatun specific actions
 * @author Charles Samuels
 **/
namespace StdAction
{

/**
 * @return pointer to a KAction which starts/pauses playback on activation
 */
NOATUN_EXPORT KAction *playpause(Global *glob, QObject *parent = 0, const char *name = "player_playpause");

/**
 * @return pointer to a KAction which opens the effects dialog on activation
 */
NOATUN_EXPORT KAction *effects(Global *glob, QObject *parent = 0, const char *name = "options_show_effects");

/**
 * @return pointer to a KAction which opens the equalizer dialog on activation
 */
NOATUN_EXPORT KAction *equalizer(Global *glob, QObject *parent = 0, const char *name = "options_show_equalizer");

/**
 * @return pointer to a KAction which goes back one track on activation
 */
NOATUN_EXPORT KAction *back(Global *glob, QObject *parent = 0, const char *name = "player_back");

/**
 * @return pointer to a KAction which advances one track on activation
 */
NOATUN_EXPORT KAction *forward(Global *glob, QObject *parent = 0, const char *name = "player_forward");

/**
 * @return pointer to a KAction which stops playback on activation
 */
NOATUN_EXPORT KAction *stop(Global *glob, QObject *parent = 0, const char *name = "player_stop");

/**
 * @return pointer to a KAction which starts playback on activation
 */
NOATUN_EXPORT KAction *play(Global *glob, QObject *parent = 0, const char *name = "player_play");

/**
 * @return pointer to a KAction which pauses playback on activation
 */
NOATUN_EXPORT KAction *pause(Global *glob, QObject *parent = 0, const char *name = "player_pause");

/**
 * @return pointer to a KToggleAction which shows/hides the playlist
 */
NOATUN_EXPORT KToggleAction *playlist(Global *glob, QObject *parent = 0, const char *name = "options_show_playlist");

/**
 * @return pointer to a KAction which exits noatun on activation
 */
NOATUN_EXPORT QAction *quit(Global *glob, QObject *parent = 0, const char *name = "file_quit");

/**
 * @brief Display the noatun preferences dialog
 * @note If you want to display the preferences dialog with a certain
 *       PreferencesPage activated then you have to call
 *       PreferencesDialog::show(PreferencesPage *)
 * @see PreferencesDialog
 * @see Global::preferencesDialog()
 */
NOATUN_EXPORT QAction *preferences(Global *glob, QObject *parent = 0, const char *name = "options_configure");

/**
 * loop action
 **/
NOATUN_EXPORT LoopActionMenu *loop(Global *glob, QObject *parent, const char *name = "player_loop");

/**
 * @return pointer to a VisActionMenu object
 */
//NOATUN_EXPORT VisActionMenu *visualizations(QObject *parent = 0, const char *name = 0);

} // END namespace StdAction

} // END namespace Noatun

#endif // STDACTION_H
