/***************************************************************************
                     A simple database-driven playlist for Noatun
                    ----------------.-----------------------------
    begin                : 02.06.2005
    copyright            : (C) 2005 by Stefan Gehn
    email                : Stefan Gehn <mETz81@web.de>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ITEMADDER_H
#define ITEMADDER_H

#include <qobject.h>
#include <qstringlist.h>
#include <kurl.h>
#include <kio/global.h>


#include <noatun/playlist.h>

class SimplePlaylist;

namespace KIO
{
	class ListJob;
	class Job;
}

class ItemAdder : public QObject
{
Q_OBJECT

public:
	ItemAdder(SimplePlaylist *pl, const KUrl &url, int afterId, bool autoplay);
	ItemAdder(SimplePlaylist *pl, const KUrl::List &urlList, int afterId, bool autoplay);
	void start();

Q_SIGNALS:
	void finished();

private:
	void addUnknown(const KUrl& url);
	int addPlaylist(const KUrl &url);
	int addFile(const KUrl &url, int length, const Noatun::PropertyMap &properties, int afterId);
	void addDirectory(const KUrl &dir);
	void addNextPendingDirectory();

private Q_SLOTS:
	void finish();
	void slotResult(KJob *job);
	void slotEntries(KIO::Job *, const KIO::UDSEntryList &entries);
	void slotRedirection(KIO::Job *, const KUrl &url);

private:
	SimplePlaylist *playlist;

	int addAfterId; /// itemid where we should insert the next item after
	int firstAddedId; /// id of the first item we added or -1 in case we added nothing (yet)
	/**
	 * recursingDirs is true if we started async directory scanning. finished
	 * signal has to be emitted after we are done with that
	 **/
	bool recursingDirs;
	bool autoPlay;
	KUrl::List urls;
	QStringList mediaMimeTypes;

	KUrl currentJobURL;
	KUrl::List pendingAddDirectories;
	KUrl::List::Iterator lastAddedSubDirectory;
	KIO::ListJob *listJob;
};

#endif
