#ifndef FIND_H
#define FIND_H

#include <kdialog.h>

class KHistoryComboBox;
class QCheckBox;

class Finder : public KDialog
{
Q_OBJECT
public:
	explicit Finder(QWidget *parent);

	bool regexp() const;
	bool isForward() const;

	QString string() const;
Q_SIGNALS:
	void search(Finder *);

public Q_SLOTS:
	void textChanged(const QString &);
	void clicked();

private:
	KHistoryComboBox *mText;
	QCheckBox *mRegexp, *mBackwards;
};

#endif

