/* This file is part of Noatun

  Copyright 2000-2006 Charles Samuels <charles@kde.org>
  Copyright 2000-2001 Neil Stevens <neil@qualityassistant.com>
  Copyright 2002 by Ryan Cumming <ryan@kde.org>
  Copyright 2003-2007 by Stefan Gehn <mETz81@web.de>

  Licensed under the "Artistic License"
*/
#ifndef VIEW_H
#define VIEW_H

#include <qevent.h>
#include <qlist.h>
#include <k3listview.h>
#include <kxmlguiwindow.h>
#include <qmap.h>
#include <kio/global.h>
#include <kio/udsentry.h>
#include <noatun/nmainwindow.h>
#include <noatun/playlistitem.h>


class Finder;
class View;
class List;
class KAction;
namespace KIO
{
	class Job;
	class ListJob;
}

class SafeListViewItem : public Q3CheckListItem
{
public:
	SafeListViewItem(List *parent, Q3ListViewItem *after, const KUrl &text);
	SafeListViewItem(List *parent, Q3ListViewItem *after, const QMap<QString,QString> &properties);
	virtual ~SafeListViewItem();

	List *listView();

	QString property(const QString &, const QString & = 0) const;
	void setProperty(const QString &, const QString &);
	void clearProperty(const QString &);
	QStringList properties() const;
	bool hasProperty(const QString &) const;

	int compare(Q3ListViewItem * i, int col, bool ascending) const;
	void remove();

	void showPlaying(bool p);

	SafeListViewItem* itemAbove() { return static_cast<SafeListViewItem*>(Q3CheckListItem::itemAbove()); }
	SafeListViewItem* itemBelow() { return static_cast<SafeListViewItem*>(Q3CheckListItem::itemBelow()); }
	SafeListViewItem* nextSibling() { return static_cast<SafeListViewItem*>(Q3CheckListItem::nextSibling()); }

protected:
	virtual void modified();
	virtual void stateChange(bool s);

private:
	struct Property
	{
		QString key;
		QString value;
	};
	QList<Property> mProperties;
	bool removed;
};



class List : public K3ListView
{
Q_OBJECT
	friend class View;
public:
	explicit List(View *parent);
	virtual ~List();

	Q3ListViewItem *addFile(const KUrl&, bool play=false, Q3ListViewItem * =0);

	void addDirectoryRecursive(const KUrl &dir, Q3ListViewItem *after = 0);

	SafeListViewItem *firstChild() { return static_cast<SafeListViewItem*>(K3ListView::firstChild()); }

public Q_SLOTS:
	virtual void clear();

Q_SIGNALS:
	void modified(void);
	void deleteCurrentItem();

protected:
	virtual bool acceptDrag(QDropEvent *event) const;
	virtual void keyPressEvent(QKeyEvent *e);

protected Q_SLOTS:
	virtual void dropEvent(QDropEvent *event, Q3ListViewItem *after);
	void move();

protected Q_SLOTS:
	// used when adding directories via KIO::listRecursive
	void slotResult(KJob *job);
	void slotEntries(KIO::Job *job, const KIO::UDSEntryList &entries);
	void slotRedirection(KIO::Job *, const KUrl & url);

protected:
	void addNextPendingDirectory();
	KUrl::List pendingAddDirectories;
	KUrl::List::Iterator lastAddedSubDirectory;
	KUrl currentJobURL;
	Q3ListViewItem *recursiveAddAfter;
	KIO::ListJob *listJob;
};



class View : public Noatun::NMainWindow
{
Q_OBJECT
public:
	explicit View(Noatun::Plugin *mother);
	virtual ~View();

	List *listView() const { return list; }
	Q3ListViewItem *addFile(const KUrl &u, bool play=false)
		{ return list->addFile(u, play, list->lastItem()); }

public Q_SLOTS:
	void deleteSelected();
	void addFiles();
	void addDirectory();
	void save();
	void saveAs();
	void open();
	void openNew();
	void setSorting(bool on, int column = 0);
	void setNoSorting() { setSorting(false); }
	void headerClicked(int column);void find();
	void findIt(Finder *);

	void saveState(KConfigGroup &grp);
	void loadState(const KConfigGroup &grp);

private Q_SLOTS:
	void setModified();

	void configureToolBars();
	void newToolBarConfig();

protected:
	void setupActions();

	bool saveToURL(const KUrl &url, const QString &mimeType);

	void setModified(bool);

private:
	List    *list;
	KAction *mAdd, *mDelete, *mSave, *mSaveAs, *mOpenpl, *mOpenNew;
	Finder  *mFinder;

	KUrl    mPlaylistFile;
	QString mPlaylistMimeType;
	bool    mModified;
};

inline List *SafeListViewItem::listView()
{
	return static_cast<List*>(Q3CheckListItem::listView());
}


#endif
