/*
 * knewsticker.h
 *
 * Copyright (c) 2000, 2001 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef KNEWSTICKER_H
#define KNEWSTICKER_H

#include <qtoolbutton.h>
//Added by qt3to4:
#include <QMouseEvent>
#include <plasma/kpanelapplet.h>
#include <kmenu.h>

#include "configiface.h"
#include "configaccess.h"
#include "newsengine.h"
#include <kcomponentdata.h>

class KComponentData;
class NewsSource;
class KArrowButton;
class NewsIconMgr;
class NewsScroller;
class KNewsTickerMenu;
class KAboutData;
class QTimer;

class KNewsTicker : public KPanelApplet, virtual public ConfigIface
{
	Q_OBJECT
        Q_CLASSINFO("D-Bus Interface", "org.kde.knewsticker.applet")

	friend class KNewsTickerMenu;

	public:
		KNewsTicker(const QString &, Plasma::Type, int, QWidget * = 0);
		virtual ~KNewsTicker();

		virtual int widthForHeight(int) const;
		virtual int heightForWidth(int) const;

	public Q_SLOTS:
		Q_SCRIPTABLE void reparseConfig();
		Q_SCRIPTABLE void updateNews() { slotUpdateNews(); }
		Q_SCRIPTABLE uint interval() const { return m_cfg->interval(); }
		Q_SCRIPTABLE uint scrollingSpeed() const { return m_cfg->scrollingSpeed(); }
		Q_SCRIPTABLE uint mouseWheelSpeed() const { return m_cfg->mouseWheelSpeed(); }
		Q_SCRIPTABLE uint scrollingDirection() const { return m_cfg->scrollingDirection(); }
		Q_SCRIPTABLE bool customNames() const { return m_cfg->customNames(); }
		Q_SCRIPTABLE bool scrollMostRecentOnly() const { return m_cfg->scrollMostRecentOnly(); }
		Q_SCRIPTABLE bool offlineMode() const { return m_cfg->offlineMode(); }
		Q_SCRIPTABLE bool underlineHighlighted() const { return m_cfg->underlineHighlighted(); }
		Q_SCRIPTABLE bool showIcons() const { return m_cfg->showIcons(); }
		Q_SCRIPTABLE bool slowedScrolling() const { return m_cfg->slowedScrolling(); }
		Q_SCRIPTABLE QColor foregroundColor() const { return m_cfg->foregroundColor(); }
		Q_SCRIPTABLE QColor backgroundColor() const { return m_cfg->backgroundColor(); }
		Q_SCRIPTABLE QColor highlightedColor() const { return m_cfg->highlightedColor(); }
		Q_SCRIPTABLE QStringList newsSources() const { return m_cfg->newsSources(); }
		Q_SCRIPTABLE void setInterval(const unsigned int);
		Q_SCRIPTABLE void setScrollingSpeed(const unsigned int);
		Q_SCRIPTABLE void setMouseWheelSpeed(const unsigned int);
		Q_SCRIPTABLE void setScrollingDirection(const unsigned int);
		Q_SCRIPTABLE void setCustomNames(bool);
		Q_SCRIPTABLE void setScrollMostRecentOnly(bool);
		Q_SCRIPTABLE void setOfflineMode(bool);
		Q_SCRIPTABLE void setUnderlineHighlighted(bool);
		Q_SCRIPTABLE void setShowIcons(bool);
		Q_SCRIPTABLE void setSlowedScrolling(bool);
		Q_SCRIPTABLE void setForegroundColor(const QColor &);
		Q_SCRIPTABLE void setBackgroundColor(const QColor &);
		Q_SCRIPTABLE void setHighlightedColor(const QColor &);
		Q_SCRIPTABLE void setNewsSources(const QStringList &) {}

	public slots:
		void slotUpdateNews();
		void slotOpenContextMenu();

	protected:
		virtual void preferences();
		virtual void about();
		virtual void help();
		virtual void reportBug();
		virtual void mousePressEvent(QMouseEvent *);
		virtual void positionChange(Plasma::Position);

	protected slots:
		void slotArrowButtonPressed();
		void slotNewsSourceUpdated(const NewsSourceBase::Ptr &, bool = false);
		void slotNewsSourceFailed(const NewsSourceBase::Ptr &);
		void slotContextMenuAboutToHide();
		void slotNotifyOfFailures();

	private:
		void setupArrowButton();

		KComponentData m_componentData;
		ConfigAccess         *m_cfg;
		KArrowButton         *m_arrowButton;
		QTimer               *m_newsTimer;
		QTimer               *m_updateTimer;
		NewsIconMgr          *m_newsIconMgr;
		NewsScroller         *m_scroller;
		KAboutData           *m_aboutData;
		KNewsTickerMenu      *m_contextMenu;
		bool                 m_newNews;
		NewsSourceBase::List m_newsSources;
		QStringList	         m_failedNewsUpdates;
		QStringList          m_pendingNewsUpdates;
};

class KNewsTickerMenu : public KMenu
{
	Q_OBJECT

	public:
		KNewsTickerMenu(KNewsTicker *, const char * = 0);
		void setFullMenu(bool full) { m_fullMenu = full; populateMenu(); }

	protected slots:
		void populateMenu();

	private slots:
		void slotShowHelp();
		void slotShowAbout();
		void slotConfigure();
		void slotToggleOfflineMode();
		void slotCheckNews(int idx);
		void slotOpenArticle(int idx);

	private:
		KNewsTicker *m_parent;
		bool m_fullMenu;
};

#endif // KNEWSTICKER_H
