/***************************************************************************
                          networkscanning.cpp  -  description
                             -------------------
    begin                : Sam Apr 24 11:44:20 CEST 2005
    copyright            : (C) 2005 by Stefan Winter
    email                : swinter@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>

#include <QString>
#include <QWidget>
#include <QLayout>
#include <QPushButton>
#include <QGridLayout>
#include <QTableView>

#include <kdebug.h>
#include <klocale.h>
#include <kprocess.h>
#include <kmessagebox.h>

#include "networkscanning.h"
#include "interface_wireless.h"
#include "ui_scanresults.h"

NetworkScanning::NetworkScanning ( Interface_wireless * dev, QWidget * parent ):QWidget ( parent )
{
  device = dev;
  networkScan (  );
}

void
NetworkScanning::networkScan (  )
{
  kDebug (  ) << "Scanning...\n";
  networks = device->get_available_networks (  );
  // we will get a signal when things are ready to be processed
  connect ( networks, SIGNAL ( finishedScanning (  ) ), this, SLOT ( displayResults (  ) ) );
}

void
NetworkScanning::displayResults (  )
{
  QModelIndex x;

  if ( networks->rowCount ( x ) == 0 )
    {
      KMessageBox::sorry ( 0, i18n ( "The scan is complete, but no networks have been found." ),
			   i18n ( "No Network Available" ) );
      return;
    }

  scanResultsContainer = new QWidget ( 0 );
  scanresults_ui.setupUi ( scanResultsContainer );

  scanresults_ui.resultsTableView->setModel ( networks );
  scanresults_ui.resultsTableView->setSelectionBehavior ( QAbstractItemView::SelectRows );
  for ( int i = 0; i < 4; i++ )
    scanresults_ui.resultsTableView->resizeColumnToContents ( i );

  connect ( scanresults_ui.resultsTableView, SIGNAL ( clicked ( const QModelIndex & ) ), this,
	    SLOT ( changeSwitchButtonState ( const QModelIndex & ) ) );
  connect ( scanresults_ui.closeButton, SIGNAL (pressed ( ) ), scanResultsContainer, SLOT ( close ( ) ) );
  scanResultsContainer->show (  );
}

void
NetworkScanning::changeSwitchButtonState ( const QModelIndex & index )
{
  scanresults_ui.switchNetworkButton->setEnabled ( index.isValid (  ) );
}

void
NetworkScanning::switchToNetwork (  )
{
/*
 * FIXME: make this work again
 * 
  WEP_KEY encryption = checkWEP();

  if (encryption == INVALID) {
    KMessageBox::sorry(0,i18n( "Aborting network switching due to invalid WEP key specification." ), i18n( "Invalid WEP Key" ));
    return;
  }

  QString cmdline;

  KTempFile* tempfile = new KTempFile( QString::null, QString::null, 0700 );
  QString tempfilename = tempfile->name();

  cmdline = (QString)"ifconfig %1 down\n";
  cmdline = cmdline.arg( device->get_interface_name() );
  write( tempfile->handle(), cmdline.ascii(), strlen( cmdline.ascii() ) );

  cmdline = (QString)"iwconfig %1 essid %2 mode %3 enc %4\n";
  cmdline = cmdline.arg( device->get_interface_name() );
  cmdline = cmdline.arg( KProcess::quote( networks->text( networks->currentRow(), 0 ) ) );
  cmdline = cmdline.arg( networks->text( networks->currentRow(), 1 ) );
  if ( encryption != NONE ) {
    cmdline = cmdline.arg( (encryption == VALID_STRING ? "s:" : "" ) + KProcess::quote( networks->text( networks->currentRow(), 3 ) ) );
  } else {
    cmdline = cmdline.arg("off");
  }
  write( tempfile->handle(), cmdline.ascii(), strlen( cmdline.ascii() ) );

  cmdline = (QString)"ifconfig %1 up\n";
  cmdline = cmdline.arg( device->get_interface_name() );
  write( tempfile->handle(), cmdline.ascii(), strlen( cmdline.ascii() ) );

  delete tempfile; // autoDeletion off, so the file remains on disk

  KProcess switchProc;
  switchProc << "kdesu" << tempfilename;
  switchProc.start( KProcess::Block );

  remove(tempfilename.ascii());
*/
}


#include "networkscanning.moc"
