# cmake macro to test LIBVNCSERVER LIB

# Copyright (c) 2006, Alessandro Praduroux <pradu@pradu.it>
# Copyright (c) 2007, Urs Wolfer <uwolfer @ kde.org>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


if (LIBVNCSERVER_INCLUDE_DIR AND LIBVNCSERVER_LIBRARIES)
    # Already in cache, be silent
    set(LibVNCServer_FIND_QUIETLY TRUE)
endif (LIBVNCSERVER_INCLUDE_DIR AND LIBVNCSERVER_LIBRARIES)

FIND_PATH(LIBVNCSERVER_INCLUDE_DIR rfb/rfb.h)

FIND_LIBRARY(LIBVNCSERVER_LIBRARIES NAMES vncserver libvncserver)

# libvncserver and libvncclient are in the same package, so it does
# not make sense to add a new cmake script for finding libvncclient.
# instead just find the libvncclient also in this file.
FIND_PATH(LIBVNCCLIENT_INCLUDE_DIR rfb/rfbclient.h)
FIND_LIBRARY(LIBVNCCLIENT_LIBRARIES NAMES vncclient libvncclient)

include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(LibVNCServer DEFAULT_MSG LIBVNCSERVER_INCLUDE_DIR LIBVNCSERVER_LIBRARIES)


MARK_AS_ADVANCED(LIBVNCSERVER_INCLUDE_DIR LIBVNCSERVER_LIBRARIES)
