#ifndef PACKAGESELECTDIALOG_H
#define PACKAGESELECTDIALOG_H

#include <q3dict.h>
//Added by qt3to4:
#include <QKeyEvent>

#include <kdialog.h>

#include "package.h"

class KCompletion;
class KLineEdit;

class PackageListView : public Q3ListView
{
    Q_OBJECT
  public:
    PackageListView( QWidget *parent );

    void resetTyped();

  signals:
    void typed( const QString & );

  protected:
    void keyPressEvent( QKeyEvent *e );
    
  private:
    QString mTyped;
};

class PackageSelectDialog : public KDialog
{
    Q_OBJECT
  public:
    PackageSelectDialog(QWidget *parent=0);
    ~PackageSelectDialog();

    void setRecentPackages( const QStringList & );
    void setPackages( const Package::List &pkgs );

    Package selectedPackage();
    QString selectedComponent();

  protected slots:
    void slotOk();

  private slots:
    void recentSelected( int, Q3ListViewItem * );
    void completeSelected( int, Q3ListViewItem * );
    void completeTyped( const QString & );

  private:
    Package::List mPackages;
    Package mSelectedPackage;
    QString mSelectedComponent;
    
    Q3ListView *mRecentList;
    PackageListView *mCompleteList;
    KLineEdit *mPackageEdit;
    KCompletion *mCompletion;
    Q3Dict<Q3ListViewItem> mCompletionDict;
};

#endif
