#ifndef PREFERENCESDIALOG_H
#define PREFERENCESDIALOG_H

#include <kpagedialog.h>

class QCheckBox;
class QRadioButton;
class Q3ListView;
class KIntNumInput;
class ServerListView;

class PreferencesDialog : public KPageDialog
{
    Q_OBJECT
  public:
    explicit PreferencesDialog( QWidget* parent = 0, const char* name = 0 );
    ~PreferencesDialog();

    void createServerItem( ServerListView *listView, const QString &name,
                           const QString &url, const QString &version );

  public:
    void readConfig();
    void writeConfig();

  signals:
    void configChanged();

  protected slots:
    void setDefaults();
    void slotApply();
    void slotOk();
    void slotCancel();

    void addServer();
    void editServer();
    void removeServer();

    void selectServer();

  protected:
    void setupServerPage();
    void setupAdvancedPage();


  private:
    QCheckBox *mShowClosedCheckBox;
    QCheckBox *mShowWishesCheckBox;
    QCheckBox *mShowVotedCheckBox;
    QCheckBox *mSendBccCheckBox;
    KIntNumInput *mMinVotesInput;
    QRadioButton *mKMailButton;
    QRadioButton *mDirectButton;
    QRadioButton *mSendmailButton;
    Q3ListView *mServerList;
};

class ServerListView;
class ServerItem;

class SelectServerDlg : public KDialog
{
    Q_OBJECT
public:
    SelectServerDlg(PreferencesDialog *parent, const char */*name*/ );
    ServerItem *serverSelected();
protected slots:
    void slotDoubleClicked( Q3ListViewItem *);

protected:
    ServerListView *list;
};


#endif
