// Copyright 2003 Ian Reinhart Geiser <geiseri@yahoo.com>
//
// GNU General Public License version 2
// See COPYING file that comes with this distribution

#include <kuniqueapplication.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <kaboutdata.h>
#include <klocale.h>
#include "weatherservice.h"
int main (int argc, char *argv[])
{
	KLocale::setMainCatalog("kdelibs");
	KAboutData aboutdata("KWeatherService", I18N_NOOP("KDE"),
				"0.8", I18N_NOOP("KWeather D-Bus Service"),
				KAboutData::License_GPL, "(C) 2002, Ian Reinhart Geiser");
	aboutdata.addAuthor("Ian Reinhart Geiser",I18N_NOOP("Developer"),"geiseri@kde.org");
	aboutdata.addAuthor("Nadeem Hasan",I18N_NOOP("Developer"),"nhasan@kde.org");
        aboutdata.addCredit("Laurent Montel", I18N_NOOP("Conversion to D-Bus"),"montel@kde.org", 0);


	KCmdLineArgs::init( argc, argv, &aboutdata );
	// KCmdLineArgs::addCmdLineOptions( options );
	KUniqueApplication::addCmdLineOptions();

	if (!KUniqueApplication::start())
	{
		kDebug() << "dbusservice is already running!" << endl;
		return (0);
	}

	KUniqueApplication app;
	// This app is started automatically, no need for session management
	app.disableSessionManagement();
	WeatherService *service = new WeatherService(&app, "WeatherService");
	return app.exec();

}
