/***************************************************************************
                            kde_BrowserExtension.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_BROWSEREXTENSION
#define KDE_BROWSEREXTENSION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The Browser Extension is an extension (yes, no kidding) to
 KParts::ReadOnlyPart, which allows a better integration of parts
 with browsers (in particular Konqueror).
 Remember that ReadOnlyPart only has openURL(KURL), with no other settings.
 For full-fledged browsing, we need much more than that, including
 many arguments about how to open this URL (see URLArgs), allowing
 parts to save and restore their data into the back/forward history,
 allowing parts to control the location bar URL, to requests URLs
 to be opened by the hosting browser, etc.

 The part developer needs to define its own class derived from BrowserExtension,
 to implement the virtual methods [and the standard-actions slots, see below].

 The way to associate the BrowserExtension with the part is to simply
 create the BrowserExtension as a child of the part (in QObject's terms).
 The hosting application will look for it automatically.

 Another aspect of the browser integration is that a set of standard
 actions are provided by the browser, but implemented by the part
 (for the actions it supports).

 The following standard actions are defined by the host of the view :

 [selection-dependent actions]

 [normal actions]

 The view defines a slot with the name of the action in order to implement the action.
 The browser will detect the slot automatically and connect its action to it when
 appropriate (i.e. when the view is active).

 The selection-dependent actions are disabled by default and the view should
 enable them when the selection changes, emitting @ref enableAction().

 The normal actions do not depend on the selection.
 You need to enable 'print' when printing is possible - you can even do that
 in the constructor.

 A special case is the configuration slots, not connected to any action directly,
 and having parameters.

 [configuration slot]

 @short *
 The Browser Extension is an extension (yes, no kidding) to
 KParts::ReadOnlyPart, which allows a better integration of parts
 with browsers (in particular Konqueror).
*/

/** *
 Constructor

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_BrowserExtension * kde_new_BrowserExtension(kde_ReadOnlyPart* parent, char* name);
void kde_del_BrowserExtension( kde_BrowserExtension* p );

/** *
 Set the parameters to use for opening the next URL.
 This is called by the "hosting" application, to pass parameters to the part.

*/
void kde_BrowserExtension_setURLArgs(kde_BrowserExtension* instPointer,kde_URLArgs* args);

/** *
 Retrieve the set of parameters to use for opening the URL
 (this must be called from openURL() in the part).

*/
kde_URLArgs* kde_BrowserExtension_urlArgs(kde_BrowserExtension* instPointer);

/** *
 Returns the current x offset.

 For a scrollview, implement this using contentsX().
   
*/
int kde_BrowserExtension_xOffset(kde_BrowserExtension* instPointer);

/** *
 Returns the current y offset.

 For a scrollview, implement this using contentsY().
   
*/
int kde_BrowserExtension_yOffset(kde_BrowserExtension* instPointer);

/** *
 Used by the browser to save the current state of the view
 (in order to restore it if going back in navigation).

 If you want to save additionnal properties, reimplement it
 but don't forget to call the parent method (probably first).
   
*/
void kde_BrowserExtension_saveState(kde_BrowserExtension* instPointer,qt_QDataStream * stream);

/** *
 Used by the browser to restore the view in the state
 it was when we left it.

 If you saved additionnal properties, reimplement it
 but don't forget to call the parent method (probably first).
   
*/
void kde_BrowserExtension_restoreState(kde_BrowserExtension* instPointer,qt_QDataStream * stream);

/** *
 Returns whether url drop handling is enabled.
 See @ref setURLDropHandlingEnabled for more information about this
 property.
   
*/
int kde_BrowserExtension_isURLDropHandlingEnabled(kde_BrowserExtension* instPointer);

/** *
 Enables or disables url drop handling. URL drop handling is a property
 describing whether the hosting shell component is allowed to install an
 event filter on the part's widget, to listen for URI drop events.
 Set it to true if you are exporting a BrowserExtension implementation and
 do not provide any special URI drop handling. If set to false you can be
 sure to receive all those URI drop events unfiltered. Also note that the
 implementation as of Konqueror installs the event filter only on the part's
 widget itself, not on child widgets.
   
*/
void kde_BrowserExtension_setURLDropHandlingEnabled(kde_BrowserExtension* instPointer,int enable);
void kde_BrowserExtension_setBrowserInterface(kde_BrowserExtension* instPointer,kde_BrowserInterface* impl);
kde_BrowserInterface* kde_BrowserExtension_browserInterface(kde_BrowserExtension* instPointer);

/** *

*/
int kde_BrowserExtension_isActionEnabled(kde_BrowserExtension* instPointer,char* name);

/** *
 Returns a map containing the action names as keys and corresponding
 SLOT()'ified method names as data entries.

 This is very useful for
 the host component, when connecting the own signals with the
 extension's slots.
 Basically you iterate over the map, check if the extension implements
 the slot and connect to the slot using the data value of your map
 iterator.
 Checking if the extension implements a certain slot can be done like this:

 <pre>
   extension->metaObject()->slotNames().contains( actionName + "()" )
 </pre>

 (note that @p actionName is the iterator's key value if already
  iterating over the action slot map, returned by this method)

 Connecting to the slot can be done like this:

 <pre>
   connect( yourObject, SIGNAL( yourSignal() ),
            extension, mapIterator.data() )
 </pre>

 (where "mapIterator" is your QMap<QCString,QCString> iterator)
   
*/

/** *

*/

/** *
 Queries @p obj for a child object which inherits from this
 BrowserExtension class. Convenience method.
   
*/
kde_BrowserExtension* kde_BrowserExtension_childObject( qt_QObject * obj);
void kde_BrowserExtension_virtual_hook(kde_BrowserExtension* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
