/***************************************************************************
                            kde_CSSStyleSheet.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_CSSSTYLESHEET
#define KDE_CSSSTYLESHEET

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The <code> CSSStyleSheet </code> interface is a concrete interface
 used to represent a CSS style sheet i.e. a style sheet whose
 content type is "text/css".

 
 @short *
 The <code> CSSStyleSheet </code> interface is a concrete interface
 used to represent a CSS style sheet i.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_CSSStyleSheet * kde_new_CSSStyleSheet();
kde_CSSStyleSheet * kde_new_CSSStyleSheet1(kde_CSSStyleSheet* other);
kde_CSSStyleSheet * kde_new_CSSStyleSheet2(kde_StyleSheet* other);
void kde_del_CSSStyleSheet( kde_CSSStyleSheet* p );

/** *
 If this style sheet comes from an <code> @import </code> rule,
 the <code> ownerRule </code> attribute will contain the <code>
 CSSImportRule </code> . In that case, the <code> ownerNode
 </code> attribute in the <code> StyleSheet </code> interface
 will be <code> null </code> . If the style sheet comes from an
 element or a processing instruction, the <code> ownerRule
 </code> attribute will be <code> null </code> and the <code>
 ownerNode </code> attribute will contain the <code> Node
 </code> .

     
*/
kde_CSSRule* kde_CSSStyleSheet_ownerRule(kde_CSSStyleSheet* instPointer);

/** *
 The list of all CSS rules contained within the style sheet.
 This includes both <a
 href="http://www.w3.org/TR/REC-CSS2/syndata.html#q8"> rule sets
 </a> and <a
 href="http://www.w3.org/TR/REC-CSS2/syndata.html#at-rules">
 at-rules </a> .

     
*/
kde_CSSRuleList* kde_CSSStyleSheet_cssRules(kde_CSSStyleSheet* instPointer);

/** *
 Used to insert a new rule into the style sheet. The new rule
 now becomes part of the cascade.

  INDEX_SIZE_ERR: Raised if the specified index is not a valid
 insertion point.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this style sheet is
 readonly.

     
*/
unsigned long kde_CSSStyleSheet_insertRule(kde_CSSStyleSheet* instPointer,kde_DOMString* rule, unsigned long index);

/** *
 Used to delete a rule from the style sheet.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this style sheet is
 readonly.

     
*/
void kde_CSSStyleSheet_deleteRule(kde_CSSStyleSheet* instPointer,unsigned long index);

#ifdef __cplusplus
}
#endif
#endif
