/***************************************************************************
                            kde_KArchiveEntry.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KARCHIVEENTRY
#define KDE_KARCHIVEENTRY

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*

 @short Base class for the archive-file's directory structure.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KArchiveEntry * kde_new_KArchiveEntry(kde_KArchive* archive, qt_QString * name, int access, int date, qt_QString * user, qt_QString * group, qt_QString * symlink);
void kde_del_KArchiveEntry( kde_KArchiveEntry* p );

/** *
 Creation date of the file.
     
*/
qt_QDateTime * kde_KArchiveEntry_datetime(kde_KArchiveEntry* instPointer);
int kde_KArchiveEntry_date(kde_KArchiveEntry* instPointer);

/** *
 Name of the file without path.
     
*/
qt_QString * kde_KArchiveEntry_name(kde_KArchiveEntry* instPointer);

/** *
 The permissions and mode flags as returned by the stat() function
 in st_mode.
     
*/
long kde_KArchiveEntry_permissions(kde_KArchiveEntry* instPointer);

/** *
 User who created the file.
     
*/
qt_QString * kde_KArchiveEntry_user(kde_KArchiveEntry* instPointer);

/** *
 Group of the user who created the file.
     
*/
qt_QString * kde_KArchiveEntry_group(kde_KArchiveEntry* instPointer);

/** *
 Symlink if there is one
     
*/
qt_QString * kde_KArchiveEntry_symlink(kde_KArchiveEntry* instPointer);

/** *

*/
int kde_KArchiveEntry_isFile(kde_KArchiveEntry* instPointer);

/** *

*/
int kde_KArchiveEntry_isDirectory(kde_KArchiveEntry* instPointer);
kde_KArchive* kde_KArchiveEntry_archive(kde_KArchiveEntry* instPointer);
void kde_KArchiveEntry_virtual_hook(kde_KArchiveEntry* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
