/***************************************************************************
                            kde_KNotifyClient.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KNOTIFYCLIENT
#define KDE_KNOTIFYCLIENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This namespace provides a method for issuing events to a KNotifyServer
 call KNotifyClient::event("eventname"); to issue it.
 On installation, there should be a file called
 $KDEDIR/share/apps/appname/eventsrc which contains the events.

 The file looks like this:
 <pre>
 [!Global!]
 IconName=Filename (e.g. kdesktop, without any extension)
 Comment=FriendlyNameOfApp

 [eventname]
 Name=FriendlyNameOfEvent
 Comment=Description Of Event
 default_sound=filetoplay.wav
 default_presentation=1
  ...
 </pre>
 default_presentation contains these ORed events:
	None=0, Sound=1, Messagebox=2, Logfile=4, Stderr=8

 KNotify will search for sound files given with a relative path first in
 the application's sound directory ( share/apps/Application Name/sounds ), then in
 the KDE global sound directory ( share/sounds ).

 You can also use the "nopresentation" key, with any the presentations
 ORed.  Those that are in that field will not appear in the kcontrol
 module.  This was intended for software like KWin to not allow a window-opening
 that opens a window (e.g., allowing to disable KMessageBoxes from appearing)
 If the user edits the eventsrc file manually, it will appear.  This only
 affects the KcmNotify.

 You can also use the following events, which are system controlled
 and do not need to be placed in your eventsrc:

<ul>
 <li>cannotopenfile
 <li>notification
 <li>warning
 <li>fatalerror
 <li>catastrophe
</ul>

 @author Charles Samuels <charles@kde.org>
 
 @short *
 This namespace provides a method for issuing events to a KNotifyServer
 call KNotifyClient::event("eventname"); to issue it.
*/
#define KNOTIFYCLIENT_Default	-1
#define KNOTIFYCLIENT_None	0
#define KNOTIFYCLIENT_Sound	1
#define KNOTIFYCLIENT_Messagebox	2
#define KNOTIFYCLIENT_Logfile	4
#define KNOTIFYCLIENT_Stderr	8
#define KNOTIFYCLIENT_PassivePopup	16
#define KNOTIFYCLIENT_Execute	32
#define KNOTIFYCLIENT_Notification	1
#define KNOTIFYCLIENT_Warning	2
#define KNOTIFYCLIENT_Error	4
#define KNOTIFYCLIENT_Catastrophe	8
#define KNOTIFYCLIENT_cannotOpenFile	0
#define KNOTIFYCLIENT_notification	1
#define KNOTIFYCLIENT_warning	2
#define KNOTIFYCLIENT_fatalError	3
#define KNOTIFYCLIENT_catastrophe	4

/** *
 This starts the KNotify Daemon, if it's not already started.
 This will be useful for games that use sound effects. Run this
 at the start of the program, and there won't be a pause when it is
 first triggered.

*/
#ifdef __cplusplus
extern   "C" {
#endif
int kde_KNotifyClient_startDaemon();

/** *
 This should be the most used method in here.
 Call it by KNotifyClient::event("EventName");
 It will use KApplication::kApplication->dcopClient() to communicate to
 the server

*/
int kde_KNotifyClient_event(kde_KNotifyClient* instPointer,qt_QString * message, qt_QString * text);

/** *
 Allows to easily emit standard events.

*/
int kde_KNotifyClient_event1(kde_KNotifyClient* instPointer,int event, qt_QString * text);

/** *
 Will fire an event that's not registered.

*/

/** *
 This is a simple substitution for QApplication::beep().
 It simply calls
 <pre>
 KNotifyClient::event( KNotifyClient::notification, reason );
 </pre>

*/

/** *
 Gets the presentation associated with a certain event name
 Remeber that they may be ORed:
 <pre>
 if (present & KNotifyClient::Sound) { [Yes, sound is a default] }	
 </pre>

*/

/** *
 Gets the default file associated with a certain event name
 The control panel module will list all the event names
 This has the potential for being slow.

*/

/** *
 Gets the default presentation for the event of this program.
 Remember that the Presentation may be ORed.  Try this:
 <pre>
 if (present & KNotifyClient::Sound) { [Yes, sound is a default] }
 </pre>

*/

/** *
 Gets the default File for the event of this program.
 It gets it in relation to present.
 Some events don't apply to this function ("Message Box")
 Some do (Sound)

*/
qt_QString * kde_KNotifyClient_getDefaultFile(kde_KNotifyClient* instPointer,qt_QString * eventname, int present);

/** *
 Shortcut to KNotifyClient::Instance::current() :)

*/
kde_KInstance* kde_KNotifyClient_instance(kde_KNotifyClient* instPointer);

#ifdef __cplusplus
}
#endif
#endif
