/***************************************************************************
                            kde_KRootProp.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KROOTPROP
#define KDE_KROOTPROP

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Access KDE desktop resources stored on the root window.

 A companion to the @ref KConfig class.

 The KRootProp class is used for reading and writing configuration entries
 to properties on the root window.

 All configuration entries are of the form "key=value".

 @author Mark Donohoe (donohe@kde.org)

 @version $Id: kde_KRootProp.h,v 1.5 2002/12/30 14:37:06 geiseri Exp $

 @short *
 Access KDE desktop resources stored on the root window.
*/

/** *
 Constructs a KRootProp object for the property @p rProp.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KRootProp * kde_new_KRootProp(qt_QString * rProp);

/** *
 Destructs the KRootProp object.

 Writes back any dirty configuration entries.

*/
void kde_del_KRootProp( kde_KRootProp* p );

/** *
 Sets the property in which keys will be searched.

*/
void kde_KRootProp_setProp(kde_KRootProp* instPointer,qt_QString * rProp);

/** *
 Returns the name of the property under which keys are searched.

*/
qt_QString * kde_KRootProp_prop(kde_KRootProp* instPointer);

/** *
 Destroys the property completely.

 I.e. all entries will be cleared
 and the property will be removed from the root window.

*/
void kde_KRootProp_destroy(kde_KRootProp* instPointer);

/** *
 Reads the value of an entry specified by @p rKey in the current property.

*/
qt_QString * kde_KRootProp_readEntry(kde_KRootProp* instPointer,qt_QString * rKey, qt_QString * pDefault);

/** *
 Reads a numerical value.

 Reads the value of an entry specified by @p rKey in the current property
 and interprets it numerically.

*/
int kde_KRootProp_readNumEntry(kde_KRootProp* instPointer,qt_QString * rKey, int nDefault);

/** *
 Reads a @ref QFont value.

 Reads the value of an entry specified by @p rKey in the current property
 and interpret it as a font object.

*/
qt_QFont * kde_KRootProp_readFontEntry(kde_KRootProp* instPointer,qt_QString * rKey, qt_QFont * pDefault);

/** *
 Reads a @ref QColor.

 Reads the value of an entry specified by @p rKey in the current property
 and interprets it as a color.

*/
qt_QColor * kde_KRootProp_readColorEntry(kde_KRootProp* instPointer,qt_QString * rKey, qt_QColor* pDefault);

/** *
 Writes a (key/value) pair.

 This is stored to the current property when destroying the
 config object or when calling @ref sync().

*/
qt_QString * kde_KRootProp_writeEntry(kde_KRootProp* instPointer,qt_QString * rKey, qt_QString * rValue);

/** *
 Writes the (key/value) pair.
 Same as above, but writes a numerical value.

*/
qt_QString * kde_KRootProp_writeEntry1(kde_KRootProp* instPointer,qt_QString * rKey, int nValue);

/** *
 Writes the (key/value) pair.
 Same as above, but writes a font.

*/
qt_QString * kde_KRootProp_writeEntry2(kde_KRootProp* instPointer,qt_QString * rKey, qt_QFont * rFont);

/** *
 Writes the (key/value) pair.
 Same as above, but writes a color.

*/
qt_QString * kde_KRootProp_writeEntry3(kde_KRootProp* instPointer,qt_QString * rKey, qt_QColor * rColor);

/** *
 Removes an entry.

*/
qt_QString * kde_KRootProp_removeEntry(kde_KRootProp* instPointer,qt_QString * rKey);

/** *
 Returns a list of all keys.

*/
qt_QStringList* kde_KRootProp_listEntries(kde_KRootProp* instPointer);

/** *
 Flushes the entry cache.
 Writes back dirty configuration entries to the current property,
 This is called automatically from the destructor.

*/
void kde_KRootProp_sync(kde_KRootProp* instPointer);

#ifdef __cplusplus
}
#endif
#endif
