/***************************************************************************
                            kde_KXYSelector.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KXYSELECTOR
#define KDE_KXYSELECTOR

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 KXYSelector is the base class for other widgets which
 provides the ability to choose from a two-dimensional
 range of values. The currently chosen value is indicated
 by a cross. An example is the @ref KHSSelector which
 allows to choose from a range of colors, and which is
 used in KColorDialog.

 A custom drawing routine for the widget surface has
 to be provided by the subclass.
 
 @short *
 KXYSelector is the base class for other widgets which
 provides the ability to choose from a two-dimensional
 range of values.
*/

/** *
 Constructs a two-dimensional selector widget which
 has a value range of [0..100] in both directions.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KXYSelector * kde_new_KXYSelector(qt_QWidget * parent, char* name);

/** *
 Destructs the widget.
   
*/
void kde_del_KXYSelector( kde_KXYSelector* p );

/** *
 Sets the current values in horizontal and
 vertical direction.
   
*/
void kde_KXYSelector_setValues(kde_KXYSelector* instPointer,int xPos, int yPos);

/** *
 Sets the range of possible values.
   
*/
void kde_KXYSelector_setRange(kde_KXYSelector* instPointer,int minX, int minY, int maxX, int maxY);

/** *

*/
int kde_KXYSelector_xValue(kde_KXYSelector* instPointer);

/** *

*/
int kde_KXYSelector_yValue(kde_KXYSelector* instPointer);

/** *

*/
qt_QRect* kde_KXYSelector_contentsRect(kde_KXYSelector* instPointer);

/** *
 Override this function to draw the contents of the widget.
 The default implementation does nothing.

 Draw within @ref contentsRect() only.
   
*/
void kde_KXYSelector_drawContents(kde_KXYSelector* instPointer,qt_QPainter * arg1);

/** *
 Override this function to draw the cursor which
 indicates the currently selected value pair.
   
*/
void kde_KXYSelector_drawCursor(kde_KXYSelector* instPointer,qt_QPainter * p, int xp, int yp);
void kde_KXYSelector_virtual_hook(kde_KXYSelector* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
