//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QRegExp;
import org.kde.qt.QWidget;
import org.kde.qt.QObject;

/**

 @brief A generic implementation of the "find" function.
 <b></b>etail:
 This class includes prompt handling etc. Also provides some
 static functions which can be used to create custom behavior
 instead of using the class directly.
 <b></b>xample:
 To use the class to implement a complete find feature:
 In the slot connected to the find action, after using KFindDialog:
 <pre>
  // This creates a find-next-prompt dialog if needed.
  m_find = new KFind(pattern, options, this);
  // Connect highlight signal to code which handles highlighting
  // of found text.
  connect( m_find, SIGNAL("highlight( String, int, int )"),
          this, SLOT("slotHighlight( String, int, int )") );
  // Connect findNext signal - called when pressing the button in the dialog
  connect( m_find, SIGNAL("findNext()"),
          this, SLOT("slotFindNext()") );
 </pre>
 If you are using a non-modal find dialog (the recommended new way
 in KDE-3.2), you should call right away m_find.closeFindNextDialog().
  Then initialize the variables determining the "current position"
  (to the cursor, if the option FromCursor is set,
   to the beginning of the selection if the option SelectedText is set,
   and to the beginning of the document otherwise).
  Initialize the "end of search" variables as well (end of doc or end of selection).
  Swap begin and end if FindBackwards.
  Finally, call slotFindNext();
 <pre>
  void slotFindNext()
  {
      KFind.Result res = KFind.NoMatch;
      while ( res == KFind.NoMatch && <position not at end> ) {
          if ( m_find.needData() )
              m_find.setData( <current text fragment> );
          // Let KFind inspect the text fragment, and display a dialog if a match is found
          res = m_find.find();
          if ( res == KFind.NoMatch ) {
              <Move to the next text fragment, honoring the FindBackwards setting for the direction>
          }
      }
      if ( res == KFind.NoMatch ) // i.e. at end
          <Call either  m_find.displayFinalDialog(); delete m_find; m_find = null;
           or           if ( m_find.shouldRestart() ) { reinit (w/o FromCursor) and call slotFindNext(); }
                        else { m_find.closeFindNextDialog(); }>
  }
 </pre>
  Don't forget to delete m_find in the destructor of your class,
  unless you gave it a parent widget on construction.
  This implementation allows to have a "Find Next" action, which resumes the
  search, even if the user closed the "Find Next" dialog.
  A "Find Previous" action can simply switch temporarily the value of
  FindBackwards and call slotFindNext() - and reset the value afterwards.
  See {@link KFindSignals} for signals emitted by KFind
		@author S.R.Haque <srhaque@iee.org>, David Faure <faure@kde.org>

		@short    @brief A generic implementation of the "find" function.

*/
public class KFind extends QObject  {
	protected KFind(Class dummy){super((Class) null);}
	public static final int NoMatch = 0;
	public static final int Match = 1;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Only use this constructor if you don't use KFindDialog, or if
		 you use it as a modal dialog.
		     		@short    Only use this constructor if you don't use KFindDialog, or if  you use it as a modal dialog.
	*/
	public KFind(String pattern, long options, QWidget parent) {
		super((Class) null);
		newKFind(pattern,options,parent);
	}
	private native void newKFind(String pattern, long options, QWidget parent);
	/**	
				@return true if the application must supply a new text fragment
 It also means the last call returned "NoMatch". But by storing this here
 the application doesn't have to store it in a member variable (between
 calls to slotFindNext()).
     
		@short
	*/
	public native boolean needData();
	/**	
		 Call this when needData returns true, before calling find().
			@param data the text fragment (line)
			@param startPos if set, the index at which the search should start.
		 This is only necessary for the very first call to setData usually,
		 for the 'find in selection' feature. A value of -1 (the default value)
		 means "process all the data", i.e. either 0 or data.length()-1 depending
		 on FindBackwards.
		     		@short    Call this when needData returns true, before calling find().
	*/
	public native void setData(String data, int startPos);
	public native void setData(String data);
	/**	
		 Walk the text fragment (e.g. text-processor line, kspread cell) looking for matches.
		 For each match, emits the highlight() signal and displays the find-again dialog
		 proceeding.
		     		@short    Walk the text fragment (e.
	*/
	public native int find();
	/**	
		 Return the current options.
			 Warning: this is usually the same value as the one passed to the constructor,
		 but options might change _during_ the replace operation:
		 e.g. the "All" button resets the PromptOnReplace flag.
			     		@short    Return the current options.
	*/
	public native long options();
	/**	
		 Set new options. Usually this is used for setting or clearing the
		 FindBackwards options.
		     		@short    Set new options.
	*/
	public native void setOptions(long options);
	/**	
				@return the pattern we're currently looking for
     
		@short
	*/
	public native String pattern();
	/**	
		 Change the pattern we're looking for
		     		@short    Change the pattern we're looking for
	*/
	public native void setPattern(String pattern);
	/**	
		 Return the number of matches found (i.e. the number of times
		 the highlight signal was emitted).
		 If 0, can be used in a dialog box to tell the user "no match was found".
		 The final dialog does so already, unless you used setDisplayFinalDialog(false).
		     		@short    Return the number of matches found (i.
	*/
	public native int numMatches();
	/**	
		 Call this to reset the numMatches count
		 (and the numReplacements count for a KReplace).
		 Can be useful if reusing the same KReplace for different operations,
		 or when restarting from the beginning of the document.
		     		@short    Call this to reset the numMatches count  (and the numReplacements count for a KReplace).
	*/
	public native void resetCounts();
	/**	
		 Virtual method, which allows applications to add extra checks for
		 validating a candidate match. It's only necessary to reimplement this
		 if the find dialog extension has been used to provide additional
		 criterias.
			@param text The current text fragment
			@param index The starting index where the candidate match was found
			@param matchedlength The length of the candidate match
		     		@short    Virtual method, which allows applications to add extra checks for  validating a candidate match.
	*/
	public native boolean validateMatch(String text, int index, int matchedlength);
	/**	
		 Returns true if we should restart the search from scratch.
		 Can ask the user, or return false (if we already searched the whole document).
			@param forceAsking set to true if the user modified the document during the
		 search. In that case it makes sense to restart the search again.
			@param showNumMatches set to true if the dialog should show the number of
		 matches. Set to false if the application provides a "find previous" action,
		 in which case the match count will be erroneous when hitting the end,
		 and we could even be hitting the beginning of the document (so not all
		 matches have even been seen).
		     		@short    Returns true if we should restart the search from scratch.
	*/
	public native boolean shouldRestart(boolean forceAsking, boolean showNumMatches);
	public native boolean shouldRestart(boolean forceAsking);
	public native boolean shouldRestart();
	/**	
		 Displays the final dialog saying "no match was found", if that was the case.
		 Call either this or shouldRestart().
		     		@short    Displays the final dialog saying "no match was found", if that was the case.
	*/
	public native void displayFinalDialog();
	/**	
		 Return (or create) the dialog that shows the "find next?" prompt.
		 Usually you don't need to call this.
		 One case where it can be useful, is when the user selects the "Find"
		 menu item while a find operation is under way. In that case, the
		 program may want to call setActiveWindow() on that dialog.
		     		@short    Return (or create) the dialog that shows the "find next?" prompt.
	*/
	public native KDialogBase findNextDialog(boolean create);
	public native KDialogBase findNextDialog();
	/**	
		 Close the "find next?" dialog. The application should do this when
		 the last match was hit. If the application deletes the KFind, then
		 "find previous" won't be possible anymore.
			 IMPORTANT: you should also call this if you are using a non-modal
		 find dialog, to tell KFind not to pop up its own dialog.
		     		@short    Close the "find next?" dialog.
	*/
	public native void closeFindNextDialog();
	/**	
				@return the current matching index ( or -1 ).
 Same as the matchingIndex parameter passed to highlight.
 You usually don't need to use this, except maybe when updating the current data,
 so you need to call setData( newData, index() ).

		@short
	*/
	public native int index();
	/**	
		 Search the given string, and returns whether a match was found. If one is,
		 the length of the string matched is also returned.
			 A performance optimised version of the function is provided for use
		 with regular expressions.
			@param text The string to search.
			@param pattern The pattern to look for.
			@param index The starting index into the string.
			@param options The options to use.
			@param matchedlength The length of the string that was matched
				@return The index at which a match was found, or -1 if no match was found.
     
		@short    Search the given string, and returns whether a match was found.
	*/
	public static native int find(String text, String pattern, int index, long options, int[] matchedlength);
	public static native int find(String text, QRegExp pattern, int index, long options, int[] matchedlength);
	protected native QWidget parentWidget();
	protected native QWidget dialogsParent();
	protected native void slotFindNext();
	protected native void slotDialogClosed();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
